/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.name.Name;

class TypeVariableResolverImpl
implements TypeVariableResolver {
    @NotNull
    private final List<TypeParameterDescriptor> typeParameters;
    @NotNull
    private final DeclarationDescriptor owner;

    public TypeVariableResolverImpl(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull DeclarationDescriptor owner) {
        this.typeParameters = typeParameters;
        this.owner = owner;
        assert (this.parametersBelongToOwner()) : "Type parameters should belong to owner: " + owner + "; " + typeParameters;
    }

    private boolean parametersBelongToOwner() {
        for (TypeParameterDescriptor typeParameter : this.typeParameters) {
            if (typeParameter.getContainingDeclaration() == this.owner) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public TypeParameterDescriptor getTypeVariable(@NotNull Name name) {
        return TypeVariableResolverImpl.getTypeVariable(name, this.typeParameters, this.owner);
    }

    @Nullable
    private static TypeParameterDescriptor getTypeVariable(@NotNull Name name, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull DeclarationDescriptor owner) {
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (!typeParameter.getName().equals(name)) continue;
            return typeParameter;
        }
        DeclarationDescriptor container = owner.getContainingDeclaration();
        if (container instanceof ClassDescriptor) {
            return TypeVariableResolverImpl.getTypeVariable(name, ((ClassDescriptor)container).getTypeConstructor().getParameters(), container);
        }
        return null;
    }
}

