/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class JavaClassNonStaticMembersScope
extends JavaClassMembersScope {
    private Collection<ConstructorDescriptor> constructors = null;
    private ConstructorDescriptor primaryConstructor = null;
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final JavaClass javaClass;
    private final boolean staticMembersOfPsiClass;

    public JavaClassNonStaticMembersScope(@NotNull ClassDescriptor descriptor, @NotNull JavaClass javaClass, boolean staticMembersOfClass, @NotNull JavaMemberResolver memberResolver) {
        super((ClassOrNamespaceDescriptor)descriptor, MembersProvider.forClass(javaClass, staticMembersOfClass), memberResolver);
        this.descriptor = descriptor;
        this.javaClass = javaClass;
        this.staticMembersOfPsiClass = staticMembersOfClass;
    }

    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        this.initConstructorsIfNeeded();
        return this.constructors;
    }

    @Nullable
    public ConstructorDescriptor getPrimaryConstructor() {
        this.initConstructorsIfNeeded();
        return this.primaryConstructor;
    }

    private void initConstructorsIfNeeded() {
        if (this.constructors == null) {
            this.constructors = this.memberResolver.resolveConstructors(this.javaClass, this.descriptor);
            for (ConstructorDescriptor constructor : this.constructors) {
                if (!constructor.isPrimary()) continue;
                if (this.primaryConstructor != null) {
                    throw new IllegalStateException("Class has more than one primary constructor: " + this.primaryConstructor + "\n" + constructor);
                }
                this.primaryConstructor = constructor;
            }
        }
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        if (this.staticMembersOfPsiClass) {
            return Collections.emptyList();
        }
        Collection<JavaClass> innerClasses = this.javaClass.getInnerClasses();
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(innerClasses.size());
        for (JavaClass innerClass : innerClasses) {
            result.add(this.resolveInnerClass(innerClass));
        }
        return result;
    }

    @NotNull
    private ClassDescriptor resolveInnerClass(@NotNull JavaClass innerClass) {
        FqName fqName = innerClass.getFqName();
        assert (fqName != null) : "Inner class has no qualified name: " + innerClass;
        ClassDescriptor classDescriptor = this.memberResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        assert (classDescriptor != null) : "Couldn't resolve inner class " + fqName;
        return classDescriptor;
    }
}

