/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaClassStaticMembersScope
extends JavaClassMembersScope {
    @NotNull
    private final FqName packageFQN;
    @NotNull
    private final JavaClass javaClass;

    public JavaClassStaticMembersScope(@NotNull NamespaceDescriptor descriptor, @NotNull FqName packageFQN, @NotNull JavaClass javaClass, @NotNull JavaMemberResolver memberResolver) {
        super((ClassOrNamespaceDescriptor)descriptor, MembersProvider.forClass(javaClass, true), memberResolver);
        this.packageFQN = packageFQN;
        this.javaClass = javaClass;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.memberResolver.resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        for (JavaClass nested : this.javaClass.getInnerClasses()) {
            NamespaceDescriptor namespace = this.getNamespace(nested.getName());
            if (namespace == null) continue;
            result.add(namespace);
        }
        return result;
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        return Collections.emptyList();
    }
}

