/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.descriptor.SamConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ProgressChecker;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaPackageScope
extends JavaBaseScope {
    @NotNull
    private final JavaPackage javaPackage;
    @NotNull
    private final FqName packageFQN;

    public JavaPackageScope(@NotNull NamespaceDescriptor descriptor, @NotNull JavaPackage javaPackage, @NotNull FqName packageFQN, @NotNull JavaMemberResolver memberResolver) {
        super(descriptor, memberResolver, MembersProvider.forPackage(javaPackage));
        this.javaPackage = javaPackage;
        this.packageFQN = packageFQN;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        ClassDescriptor classDescriptor = this.memberResolver.resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (classDescriptor == null || classDescriptor.getKind().isObject()) {
            return null;
        }
        return classDescriptor;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        ClassDescriptor classDescriptor = this.memberResolver.resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (classDescriptor != null && classDescriptor.getKind().isObject()) {
            return classDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.memberResolver.resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        result.addAll(this.computeAllPackageDeclarations());
        return result;
    }

    @NotNull
    private Collection<DeclarationDescriptor> computeAllPackageDeclarations() {
        HashSet<DeclarationDescriptor> result = new HashSet<DeclarationDescriptor>();
        for (JavaPackage subPackage : this.javaPackage.getSubPackages()) {
            NamespaceDescriptor childNs = this.memberResolver.resolveNamespace(subPackage.getFqName(), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
            if (childNs == null) continue;
            result.add(childNs);
        }
        for (JavaClass javaClass : DescriptorResolverUtils.getClassesInPackage(this.javaPackage)) {
            NamespaceDescriptor namespace;
            if (DescriptorResolverUtils.isCompiledKotlinPackageClass(javaClass) || javaClass.getOriginKind() == JavaClass.OriginKind.KOTLIN_LIGHT_CLASS || javaClass.getVisibility() != Visibilities.PUBLIC) continue;
            ProgressChecker.getInstance().checkCanceled();
            FqName fqName = javaClass.getFqName();
            if (fqName == null) continue;
            ClassDescriptor classDescriptor = this.memberResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
            if (classDescriptor != null) {
                result.add(classDescriptor);
            }
            if ((namespace = this.memberResolver.resolveNamespace(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES)) == null) continue;
            result.add(namespace);
        }
        return result;
    }

    @Override
    @NotNull
    protected Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name name) {
        NamedMembers members = this.membersProvider.get(name);
        if (members == null) {
            return Collections.emptySet();
        }
        SamConstructorDescriptor samConstructor = JavaFunctionResolver.resolveSamConstructor((NamespaceDescriptor)this.descriptor, members);
        if (samConstructor == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(samConstructor);
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        return Collections.emptyList();
    }
}

