/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.scope.MembersCache;
import org.jetbrains.jet.lang.resolve.java.scope.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.name.Name;

class MembersProvider {
    @Nullable
    private final JavaClass javaClass;
    @Nullable
    private final JavaPackage javaPackage;
    private final boolean staticMembers;
    private MembersCache membersCache;

    private MembersProvider(@Nullable JavaClass javaClass, @Nullable JavaPackage javaPackage, boolean staticMembers) {
        this.javaClass = javaClass;
        this.javaPackage = javaPackage;
        this.staticMembers = staticMembers;
    }

    @NotNull
    public static MembersProvider forPackage(@NotNull JavaPackage javaPackage) {
        return new MembersProvider(null, javaPackage, true);
    }

    @NotNull
    public static MembersProvider forClass(@NotNull JavaClass javaClass, boolean staticMembers) {
        return new MembersProvider(javaClass, null, staticMembers);
    }

    @Nullable
    public NamedMembers get(@NotNull Name name) {
        return this.getMembersCache().get(name);
    }

    @NotNull
    public Collection<NamedMembers> allMembers() {
        return this.getMembersCache().allMembers();
    }

    @NotNull
    private MembersCache getMembersCache() {
        if (this.membersCache == null) {
            if (this.javaClass != null) {
                this.membersCache = MembersCache.buildForClass(this.javaClass, this.staticMembers);
            } else if (this.javaPackage != null) {
                this.membersCache = MembersCache.buildForPackage(this.javaPackage);
            } else {
                throw new IllegalStateException("MembersProvider should be created either for a class or for a package");
            }
        }
        return this.membersCache;
    }
}

