/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotationArgument;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationAsAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaArrayAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassObjectAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaLiteralAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaReferenceAnnotationArgumentImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class JavaAnnotationArgumentImpl<Psi extends PsiAnnotationMemberValue>
extends JavaElementImpl<Psi>
implements JavaAnnotationArgument {
    private final Name name;

    protected JavaAnnotationArgumentImpl(@NotNull Psi psiAnnotationMemberValue, @Nullable Name name) {
        super(psiAnnotationMemberValue);
        this.name = name;
    }

    @NotNull
    static JavaAnnotationArgument create(@NotNull PsiAnnotationMemberValue argument, @Nullable Name name) {
        Object value = JavaPsiFacade.getInstance(argument.getProject()).getConstantEvaluationHelper().computeConstantExpression(argument);
        if (value != null || argument instanceof PsiLiteralExpression) {
            return new JavaLiteralAnnotationArgumentImpl(name, value);
        }
        if (argument instanceof PsiReferenceExpression) {
            return new JavaReferenceAnnotationArgumentImpl((PsiReferenceExpression)argument, name);
        }
        if (argument instanceof PsiArrayInitializerMemberValue) {
            return new JavaArrayAnnotationArgumentImpl((PsiArrayInitializerMemberValue)argument, name);
        }
        if (argument instanceof PsiAnnotation) {
            return new JavaAnnotationAsAnnotationArgumentImpl((PsiAnnotation)argument, name);
        }
        if (argument instanceof PsiClassObjectAccessExpression) {
            return new JavaClassObjectAnnotationArgumentImpl((PsiClassObjectAccessExpression)argument, name);
        }
        throw new UnsupportedOperationException("Unsupported annotation argument type: " + argument);
    }

    @Override
    @Nullable
    public Name getName() {
        return this.name;
    }
}

