/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.resolve.java.jetAsJava.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaClassImpl
extends JavaClassifierImpl<PsiClass>
implements JavaClass,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    public JavaClassImpl(@NotNull PsiClass psiClass) {
        super(psiClass);
        assert (!(psiClass instanceof PsiTypeParameter)) : "PsiTypeParameter should be wrapped in JavaTypeParameter, not JavaClass: use JavaClassifier.create()";
    }

    @Override
    @NotNull
    public Collection<JavaClass> getInnerClasses() {
        return JavaElementCollectionFromPsiArrayUtil.classes(((PsiClass)this.getPsi()).getInnerClasses());
    }

    @Override
    @Nullable
    public FqName getFqName() {
        String qualifiedName = ((PsiClass)this.getPsi()).getQualifiedName();
        return qualifiedName == null ? null : new FqName(qualifiedName);
    }

    @Override
    @NotNull
    public Name getName() {
        return Name.identifier(((PsiClass)this.getPsi()).getName());
    }

    @Override
    public boolean isInterface() {
        return ((PsiClass)this.getPsi()).isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return ((PsiClass)this.getPsi()).isAnnotationType();
    }

    @Override
    public boolean isEnum() {
        return ((PsiClass)this.getPsi()).isEnum();
    }

    @Override
    @Nullable
    public JavaClass getOuterClass() {
        PsiClass outer = ((PsiClass)this.getPsi()).getContainingClass();
        return outer == null ? null : new JavaClassImpl(outer);
    }

    @Override
    @NotNull
    public Collection<JavaTypeParameter> getTypeParameters() {
        return JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiClass)this.getPsi()).getTypeParameters());
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        Collection<JavaClassifierType> superClasses = JavaElementCollectionFromPsiArrayUtil.classifierTypes(((PsiClass)this.getPsi()).getExtendsListTypes());
        Collection<JavaClassifierType> superInterfaces = JavaElementCollectionFromPsiArrayUtil.classifierTypes(((PsiClass)this.getPsi()).getImplementsListTypes());
        return ContainerUtil.collect(ContainerUtil.concat(superClasses, superInterfaces).iterator());
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getMethods() {
        return JavaElementCollectionFromPsiArrayUtil.methods(((PsiClass)this.getPsi()).getMethods());
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getAllMethods() {
        return JavaElementCollectionFromPsiArrayUtil.methods(((PsiClass)this.getPsi()).getAllMethods());
    }

    @Override
    @NotNull
    public Collection<JavaField> getFields() {
        return JavaElementCollectionFromPsiArrayUtil.fields(((PsiClass)this.getPsi()).getFields());
    }

    @Override
    @NotNull
    public Collection<JavaField> getAllFields() {
        return JavaElementCollectionFromPsiArrayUtil.fields(((PsiClass)this.getPsi()).getAllFields());
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getConstructors() {
        return JavaElementCollectionFromPsiArrayUtil.methods(((PsiClass)this.getPsi()).getConstructors());
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return JavaElementUtil.getVisibility(this);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return JavaElementUtil.getAnnotations(this);
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName) {
        return JavaElementUtil.findAnnotation(this, fqName);
    }

    @Override
    @NotNull
    public JavaClassifierType getDefaultType() {
        return new JavaClassifierTypeImpl(JavaPsiFacade.getElementFactory(((PsiClass)this.getPsi()).getProject()).createType((PsiClass)this.getPsi()));
    }

    @Override
    @NotNull
    public JavaClass.OriginKind getOriginKind() {
        PsiClass psiClass = (PsiClass)this.getPsi();
        if (psiClass instanceof JetJavaMirrorMarker) {
            return JavaClass.OriginKind.KOTLIN_LIGHT_CLASS;
        }
        if (psiClass instanceof PsiCompiledElement) {
            return JavaClass.OriginKind.COMPILED;
        }
        return JavaClass.OriginKind.SOURCE;
    }
}

