/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeSubstitutorImpl;

public class JavaClassifierTypeImpl
extends JavaTypeImpl<PsiClassType>
implements JavaClassifierType {
    private ResolutionResult resolutionResult;

    public JavaClassifierTypeImpl(@NotNull PsiClassType psiClassType) {
        super(psiClassType);
    }

    @Override
    @Nullable
    public JavaClassifier getClassifier() {
        this.resolve();
        return this.resolutionResult.classifier;
    }

    @Override
    @NotNull
    public JavaTypeSubstitutor getSubstitutor() {
        this.resolve();
        return this.resolutionResult.substitutor;
    }

    private void resolve() {
        if (this.resolutionResult == null) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)this.getPsi()).resolveGenerics();
            PsiClass psiClass = result.getElement();
            this.resolutionResult = new ResolutionResult(psiClass == null ? null : JavaClassifierImpl.create(psiClass), new JavaTypeSubstitutorImpl(result.getSubstitutor()));
        }
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        PsiType[] psiTypes = ((PsiClassType)this.getPsi()).getSuperTypes();
        if (psiTypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<JavaClassifierType> result = new ArrayList<JavaClassifierType>(psiTypes.length);
        for (PsiType psiType : psiTypes) {
            if (!(psiType instanceof PsiClassType)) {
                throw new IllegalStateException("Supertype should be a class: " + psiType + ", type: " + this.getPsi());
            }
            result.add(new JavaClassifierTypeImpl((PsiClassType)psiType));
        }
        return result;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return ((PsiClassType)this.getPsi()).getPresentableText();
    }

    @Override
    public boolean isRaw() {
        return ((PsiClassType)this.getPsi()).isRaw();
    }

    @Override
    @NotNull
    public Collection<JavaType> getTypeArguments() {
        return JavaElementCollectionFromPsiArrayUtil.types(((PsiClassType)this.getPsi()).getParameters());
    }

    private static class ResolutionResult {
        private final JavaClassifier classifier;
        private final JavaTypeSubstitutor substitutor;

        private ResolutionResult(@Nullable JavaClassifier classifier, @NotNull JavaTypeSubstitutor substitutor) {
            this.classifier = classifier;
            this.substitutor = substitutor;
        }
    }
}

