/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMember;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class JavaMemberImpl<Psi extends PsiMember>
extends JavaElementImpl<Psi>
implements JavaMember,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    protected JavaMemberImpl(@NotNull Psi psiMember) {
        super(psiMember);
    }

    @Override
    @NotNull
    public Name getName() {
        String name = ((PsiMember)this.getPsi()).getName();
        assert (name != null) : "Member must have a name: " + this.getPsi();
        return Name.identifier(name);
    }

    @Override
    @NotNull
    public JavaClass getContainingClass() {
        PsiClass psiClass = ((PsiMember)this.getPsi()).getContainingClass();
        assert (psiClass != null) : "Member must have a containing class: " + this.getPsi();
        return new JavaClassImpl(psiClass);
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return JavaElementUtil.getVisibility(this);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        return JavaElementUtil.getAnnotations(this);
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName) {
        return JavaElementUtil.findAnnotation(this, fqName);
    }
}

