/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMemberImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaMethodImpl
extends JavaMemberImpl<PsiMethod>
implements JavaMethod {
    public JavaMethodImpl(@NotNull PsiMethod psiMethod) {
        super(psiMethod);
    }

    @Override
    @NotNull
    public Name getName() {
        return Name.identifier(((PsiMethod)this.getPsi()).getName());
    }

    @Override
    @NotNull
    public Collection<JavaTypeParameter> getTypeParameters() {
        return JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiMethod)this.getPsi()).getTypeParameters());
    }

    @Override
    @NotNull
    public Collection<JavaValueParameter> getValueParameters() {
        return JavaElementCollectionFromPsiArrayUtil.valueParameters(((PsiMethod)this.getPsi()).getParameterList().getParameters());
    }

    @Override
    public boolean hasAnnotationParameterDefaultValue() {
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        return psiMethod instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)psiMethod).getDefaultValue() != null;
    }

    @Override
    @Nullable
    public JavaType getReturnType() {
        PsiType psiType = ((PsiMethod)this.getPsi()).getReturnType();
        return psiType == null ? null : JavaTypeImpl.create(psiType);
    }

    @Override
    public boolean isVararg() {
        return ((PsiMethod)this.getPsi()).isVarArgs();
    }

    @Override
    public boolean isConstructor() {
        return ((PsiMethod)this.getPsi()).isConstructor();
    }
}

