/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaArrayTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPrimitiveTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaWildcardTypeImpl;

public abstract class JavaTypeImpl<Psi extends PsiType>
implements JavaType {
    private final Psi psiType;

    public JavaTypeImpl(@NotNull Psi psiType) {
        this.psiType = psiType;
    }

    @NotNull
    public Psi getPsi() {
        return this.psiType;
    }

    @NotNull
    public static JavaTypeImpl<?> create(@NotNull PsiType psiType) {
        return (JavaTypeImpl)psiType.accept(new PsiTypeVisitor<JavaTypeImpl<?>>(){

            @Override
            @Nullable
            public JavaTypeImpl<?> visitType(PsiType type) {
                throw new UnsupportedOperationException("Unsupported PsiType: " + type);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return new JavaPrimitiveTypeImpl(primitiveType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitArrayType(PsiArrayType arrayType) {
                return new JavaArrayTypeImpl(arrayType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitClassType(PsiClassType classType) {
                return new JavaClassifierTypeImpl(classType);
            }

            @Override
            @Nullable
            public JavaTypeImpl<?> visitWildcardType(PsiWildcardType wildcardType) {
                return new JavaWildcardTypeImpl(wildcardType);
            }
        });
    }

    public int hashCode() {
        return this.getPsi().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaTypeImpl && this.getPsi().equals(((JavaTypeImpl)obj).getPsi());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getPsi();
    }
}

