/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.intellij.openapi.util.Computable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.util.lazy.RecursionIntolerantLazyValue;

public abstract class AbstractLazyTypeParameterDescriptor
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final DeclarationDescriptor containingDeclaration;
    private final Name name;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<JetType> defaultType;
    private final NotNullLazyValue<Set<JetType>> upperBounds;
    private final NotNullLazyValue<JetType> upperBoundsAsType;

    public AbstractLazyTypeParameterDescriptor(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index) {
        this.variance = variance;
        this.containingDeclaration = containingDeclaration;
        this.index = index;
        this.name = name;
        this.reified = isReified;
        this.typeConstructor = storageManager.createLazyValue(new Computable<TypeConstructor>(){

            @Override
            public TypeConstructor compute() {
                return AbstractLazyTypeParameterDescriptor.this.createTypeConstructor();
            }
        });
        this.defaultType = storageManager.createLazyValue(new Computable<JetType>(){

            @Override
            public JetType compute() {
                return AbstractLazyTypeParameterDescriptor.this.createDefaultType();
            }
        });
        this.upperBounds = storageManager.createLazyValue(new Computable<Set<JetType>>(){

            @Override
            public Set<JetType> compute() {
                return AbstractLazyTypeParameterDescriptor.this.resolveUpperBounds();
            }
        });
        this.upperBoundsAsType = storageManager.createLazyValue(new Computable<JetType>(){

            @Override
            public JetType compute() {
                return AbstractLazyTypeParameterDescriptor.this.computeUpperBoundsAsType();
            }
        });
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    @NotNull
    public Variance getVariance() {
        return this.variance;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        return this.upperBounds.compute();
    }

    @NotNull
    protected abstract Set<JetType> resolveUpperBounds();

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        return this.upperBoundsAsType.compute();
    }

    @NotNull
    private JetType computeUpperBoundsAsType() {
        Set<JetType> upperBounds = this.getUpperBounds();
        assert (upperBounds.size() > 0) : "Upper bound list is empty in " + this.getName();
        JetType upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, upperBounds);
        if (upperBoundsAsType == null) {
            upperBoundsAsType = KotlinBuiltIns.getInstance().getNothingType();
        }
        return upperBoundsAsType;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        return Collections.singleton(this.getLowerBoundsAsType());
    }

    @Override
    @NotNull
    public JetType getLowerBoundsAsType() {
        return KotlinBuiltIns.getInstance().getNothingType();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor.compute();
    }

    @NotNull
    private TypeConstructor createTypeConstructor() {
        return new TypeConstructor(){

            @Override
            @NotNull
            public Collection<JetType> getSupertypes() {
                return AbstractLazyTypeParameterDescriptor.this.getUpperBounds();
            }

            @Override
            @NotNull
            public List<TypeParameterDescriptor> getParameters() {
                return Collections.emptyList();
            }

            @Override
            public boolean isSealed() {
                return false;
            }

            @Override
            public boolean isDenotable() {
                return true;
            }

            @Override
            public ClassifierDescriptor getDeclarationDescriptor() {
                return AbstractLazyTypeParameterDescriptor.this;
            }

            @Override
            public List<AnnotationDescriptor> getAnnotations() {
                return AbstractLazyTypeParameterDescriptor.this.getAnnotations();
            }

            public String toString() {
                return AbstractLazyTypeParameterDescriptor.this.getName().toString();
            }
        };
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        return this.defaultType.compute();
    }

    @NotNull
    private JetType createDefaultType() {
        return new JetTypeImpl(this.getTypeConstructor(), new LazyScopeAdapter(new RecursionIntolerantLazyValue<JetScope>(){

            @Override
            protected JetScope compute() {
                return AbstractLazyTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
            }
        }));
    }

    @Override
    public JetType getClassObjectType() {
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitTypeParameterDescriptor(this, data);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        visitor.visitTypeParameterDescriptor(this, null);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    public String toString() {
        try {
            return DescriptorRenderer.DEBUG_TEXT.render(this);
        }
        catch (Exception e) {
            return this.getClass().getName() + "@" + System.identityHashCode(this);
        }
    }
}

