/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class LazyTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor
implements TypeParameterDescriptor,
LazyDescriptor {
    private final ResolveSession resolveSession;
    private final JetTypeParameter jetTypeParameter;

    public LazyTypeParameterDescriptor(@NotNull ResolveSession resolveSession, @NotNull LazyClassDescriptor containingDeclaration, @NotNull JetTypeParameter jetTypeParameter, int index) {
        super(resolveSession.getStorageManager(), containingDeclaration, ResolveSessionUtils.safeNameForLazyResolve(jetTypeParameter.getNameAsName()), jetTypeParameter.getVariance(), jetTypeParameter.hasModifier(JetTokens.REIFIED_KEYWORD), index);
        this.resolveSession = resolveSession;
        this.jetTypeParameter = jetTypeParameter;
        this.resolveSession.getTrace().record(BindingContext.TYPE_PARAMETER, jetTypeParameter, this);
    }

    @Override
    @NotNull
    protected Set<JetType> resolveUpperBounds() {
        LinkedHashSet<JetType> upperBounds = Sets.newLinkedHashSet();
        JetTypeParameter jetTypeParameter = this.jetTypeParameter;
        this.resolveUpperBoundsFromWhereClause(upperBounds, false);
        JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
        if (extendsBound != null) {
            upperBounds.add(this.resolveBoundType(extendsBound));
        }
        if (upperBounds.isEmpty()) {
            upperBounds.add(KotlinBuiltIns.getInstance().getDefaultBound());
        }
        return upperBounds;
    }

    private void resolveUpperBoundsFromWhereClause(Set<JetType> upperBounds, boolean forClassObject) {
        JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)this.jetTypeParameter, JetClassOrObject.class);
        if (classOrObject instanceof JetClass) {
            JetClass jetClass = (JetClass)classOrObject;
            for (JetTypeConstraint jetTypeConstraint : jetClass.getTypeConstraints()) {
                JetTypeReference boundTypeReference;
                JetSimpleNameExpression constrainedParameterName;
                if (jetTypeConstraint.isClassObjectContraint() != forClassObject || (constrainedParameterName = jetTypeConstraint.getSubjectTypeParameterName()) == null || !this.getName().equals(constrainedParameterName.getReferencedNameAsName()) || (boundTypeReference = jetTypeConstraint.getBoundTypeReference()) == null) continue;
                upperBounds.add(this.resolveBoundType(boundTypeReference));
            }
        }
    }

    private JetType resolveBoundType(@NotNull JetTypeReference boundTypeReference) {
        return this.resolveSession.getInjector().getTypeResolver().resolveType(this.getContainingDeclaration().getScopeForClassHeaderResolution(), boundTypeReference, this.resolveSession.getTrace(), false);
    }

    @Override
    @NotNull
    public LazyClassDescriptor getContainingDeclaration() {
        return (LazyClassDescriptor)super.getContainingDeclaration();
    }

    @Override
    public void forceResolveAllContents() {
        this.getAnnotations();
        this.getClassObjectType();
        this.getContainingDeclaration();
        this.getDefaultType();
        this.getIndex();
        this.getLowerBounds();
        this.getLowerBoundsAsType();
        this.getOriginal();
        this.getTypeConstructor();
        this.getUpperBounds();
        this.getUpperBoundsAsType();
        this.getVariance();
    }
}

