/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeReconstructionResult;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUnifier;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;

public class CastDiagnosticsUtil {
    public static boolean isCastPossible(@NotNull JetType lhsType, @NotNull JetType rhsType, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        if (CastDiagnosticsUtil.isRelated(lhsType, rhsType, platformToKotlinClassMap)) {
            return true;
        }
        if (CastDiagnosticsUtil.isTypeParameter(lhsType) || CastDiagnosticsUtil.isTypeParameter(rhsType)) {
            return true;
        }
        if (CastDiagnosticsUtil.isFinal(lhsType) || CastDiagnosticsUtil.isFinal(rhsType)) {
            return false;
        }
        return CastDiagnosticsUtil.isTrait(lhsType) || CastDiagnosticsUtil.isTrait(rhsType);
    }

    private static boolean isRelated(@NotNull JetType a, @NotNull JetType b, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        List<JetType> aTypes = CastDiagnosticsUtil.mapToPlatformIndependentTypes(a, platformToKotlinClassMap);
        List<JetType> bTypes = CastDiagnosticsUtil.mapToPlatformIndependentTypes(b, platformToKotlinClassMap);
        for (JetType aType : aTypes) {
            for (JetType bType : bTypes) {
                if (JetTypeChecker.INSTANCE.isSubtypeOf(aType, bType)) {
                    return true;
                }
                if (!JetTypeChecker.INSTANCE.isSubtypeOf(bType, aType)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<JetType> mapToPlatformIndependentTypes(@NotNull JetType type, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (!(descriptor instanceof ClassDescriptor)) {
            return Collections.singletonList(type);
        }
        ClassDescriptor originalClass = (ClassDescriptor)descriptor;
        Collection<ClassDescriptor> kotlinClasses = platformToKotlinClassMap.mapPlatformClass(originalClass);
        if (kotlinClasses.isEmpty()) {
            return Collections.singletonList(type);
        }
        ArrayList<JetType> result = Lists.newArrayListWithCapacity(2);
        result.add(type);
        for (ClassDescriptor classDescriptor : kotlinClasses) {
            JetType kotlinType = TypeUtils.substituteProjectionsForParameters(classDescriptor, type.getArguments());
            result.add(kotlinType);
        }
        return result;
    }

    private static boolean isTypeParameter(@NotNull JetType type) {
        return type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    private static boolean isFinal(@NotNull JetType type) {
        return !TypeUtils.canHaveSubtypes(JetTypeChecker.INSTANCE, type);
    }

    private static boolean isTrait(@NotNull JetType type) {
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() == ClassKind.TRAIT;
    }

    public static boolean isCastErased(@NotNull JetType supertype, @NotNull JetType subtype, @NotNull JetTypeChecker typeChecker) {
        if (supertype.isNullable() || subtype.isNullable()) {
            return CastDiagnosticsUtil.isCastErased(TypeUtils.makeNotNullable(supertype), TypeUtils.makeNotNullable(subtype), typeChecker);
        }
        if (typeChecker.isSubtypeOf(supertype, subtype)) {
            return false;
        }
        if (CastDiagnosticsUtil.isTypeParameter(subtype)) {
            return true;
        }
        if (CastDiagnosticsUtil.allParametersReified(subtype)) {
            return false;
        }
        JetType staticallyKnownSubtype = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype, subtype.getConstructor()).getResultingType();
        if (staticallyKnownSubtype == null) {
            return true;
        }
        return !typeChecker.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    public static TypeReconstructionResult findStaticallyKnownSubtype(@NotNull JetType supertype, @NotNull TypeConstructor subtypeConstructor) {
        HashMap<TypeConstructor, TypeProjection> substitution;
        assert (!supertype.isNullable()) : "This method only makes sense for non-nullable types";
        ClassifierDescriptor descriptor = subtypeConstructor.getDeclarationDescriptor();
        assert (descriptor != null) : "Can't create default type for " + subtypeConstructor;
        JetType subtypeWithVariables = descriptor.getDefaultType();
        JetType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype);
        final List<TypeParameterDescriptor> variables = subtypeWithVariables.getConstructor().getParameters();
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult solution = TypeUnifier.unify(new TypeProjection(supertype), new TypeProjection(supertypeWithVariables), new Predicate<TypeConstructor>(){

                @Override
                public boolean apply(TypeConstructor typeConstructor) {
                    ClassifierDescriptor descriptor = typeConstructor.getDeclarationDescriptor();
                    return descriptor instanceof TypeParameterDescriptor && variables.contains(descriptor);
                }
            });
            substitution = Maps.newHashMap(solution.getSubstitution());
        } else {
            substitution = Maps.newHashMapWithExpectedSize(variables.size());
        }
        boolean allArgumentsInferred = true;
        for (TypeParameterDescriptor variable : variables) {
            TypeProjection value = (TypeProjection)substitution.get(variable.getTypeConstructor());
            if (value != null) continue;
            substitution.put(variable.getTypeConstructor(), SubstitutionUtils.makeStarProjection(variable));
            allArgumentsInferred = false;
        }
        JetType substituted = TypeSubstitutor.create(substitution).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private static boolean allParametersReified(JetType subtype) {
        for (TypeParameterDescriptor parameterDescriptor : subtype.getConstructor().getParameters()) {
            if (parameterDescriptor.isReified()) continue;
            return false;
        }
        return true;
    }

    private CastDiagnosticsUtil() {
    }
}

