/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;

public class TypeConstructorImpl
extends AnnotatedImpl
implements TypeConstructor {
    private final List<TypeParameterDescriptor> parameters;
    private Collection<JetType> supertypes;
    private final String debugName;
    private final boolean sealed;
    @Nullable
    private final ClassifierDescriptor classifierDescriptor;

    public TypeConstructorImpl(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull List<AnnotationDescriptor> annotations, boolean sealed, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters, @NotNull Collection<JetType> supertypes) {
        super(annotations);
        this.classifierDescriptor = classifierDescriptor;
        this.sealed = sealed;
        this.debugName = debugName;
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeParameterDescriptor>(parameters));
        this.supertypes = Collections.unmodifiableCollection(supertypes);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        return this.supertypes;
    }

    public String toString() {
        return this.debugName;
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public boolean isDenotable() {
        return true;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return this.classifierDescriptor;
    }
}

