/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class DescriptorRendererImpl
implements DescriptorRenderer {
    private static final Set<String> KEYWORDS = Sets.newHashSet();
    private final boolean shortNames;
    private final boolean withDefinedIn;
    private final Set<DescriptorRenderer.Modifier> modifiers;
    private final boolean startFromName;
    private final boolean debugMode;
    private final boolean classWithPrimaryConstructor;
    private final boolean verbose;
    private final boolean unitReturnType;
    private final boolean normalizedVisibilities;
    private final boolean showInternalKeyword;
    private final boolean alwaysRenderAny;
    private final boolean prettyFunctionTypes;
    @NotNull
    private final DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy;
    @NotNull
    private final DescriptorRenderer.ValueParametersHandler handler;
    @NotNull
    private final DescriptorRenderer.TextFormat textFormat;
    @NotNull
    private final Set<FqName> excludedAnnotationClasses;

    DescriptorRendererImpl(boolean shortNames, boolean withDefinedIn, Set<DescriptorRenderer.Modifier> modifiers, boolean startFromName, boolean debugMode, boolean classWithPrimaryConstructor, boolean verbose, boolean unitReturnType, boolean normalizedVisibilities, boolean showInternalKeyword, boolean alwaysRenderAny, boolean prettyFunctionTypes, @NotNull DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy, @NotNull DescriptorRenderer.ValueParametersHandler handler, @NotNull DescriptorRenderer.TextFormat textFormat, @NotNull Collection<FqName> excludedAnnotationClasses) {
        this.shortNames = shortNames;
        this.withDefinedIn = withDefinedIn;
        this.modifiers = modifiers;
        this.startFromName = startFromName;
        this.handler = handler;
        this.classWithPrimaryConstructor = classWithPrimaryConstructor;
        this.verbose = verbose;
        this.unitReturnType = unitReturnType;
        this.normalizedVisibilities = normalizedVisibilities;
        this.showInternalKeyword = showInternalKeyword;
        this.overrideRenderingPolicy = overrideRenderingPolicy;
        this.debugMode = debugMode;
        this.textFormat = textFormat;
        this.excludedAnnotationClasses = Sets.newHashSet(excludedAnnotationClasses);
        this.alwaysRenderAny = alwaysRenderAny;
        this.prettyFunctionTypes = prettyFunctionTypes;
    }

    @NotNull
    private String renderKeyword(@NotNull String keyword) {
        switch (this.textFormat) {
            case PLAIN: {
                return keyword;
            }
            case HTML: {
                return "<b>" + keyword + "</b>";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String escape(@NotNull String string) {
        switch (this.textFormat) {
            case PLAIN: {
                return string;
            }
            case HTML: {
                return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String lt() {
        return this.escape("<");
    }

    @NotNull
    private String arrow() {
        switch (this.textFormat) {
            case PLAIN: {
                return this.escape("->");
            }
            case HTML: {
                return "&rarr;";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderMessage(@NotNull String message) {
        switch (this.textFormat) {
            case PLAIN: {
                return message;
            }
            case HTML: {
                return "<i>" + message + "</i>";
            }
        }
        throw new IllegalStateException("Unexpected textFormat: " + (Object)((Object)this.textFormat));
    }

    @NotNull
    private String renderName(@NotNull Name identifier) {
        String asString = identifier.toString();
        return this.escape(KEYWORDS.contains(asString) ? '`' + asString + '`' : asString);
    }

    private void renderName(@NotNull DeclarationDescriptor descriptor, @NotNull StringBuilder builder) {
        builder.append(this.renderName(descriptor.getName()));
    }

    @NotNull
    private String renderFqName(@NotNull FqNameUnsafe fqName) {
        return this.renderFqName(fqName.pathSegments());
    }

    @NotNull
    private String renderFqName(@NotNull List<Name> pathSegments) {
        StringBuilder buf = new StringBuilder();
        for (Name element : pathSegments) {
            if (buf.length() != 0) {
                buf.append(".");
            }
            buf.append(this.renderName(element));
        }
        return buf.toString();
    }

    @NotNull
    private String renderClassName(@NotNull ClassDescriptor klass) {
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        if (this.shortNames) {
            ArrayList<Name> qualifiedNameElements = Lists.newArrayList();
            DeclarationDescriptor current = klass;
            do {
                if (current.getKind() == ClassKind.CLASS_OBJECT) continue;
                qualifiedNameElements.add(current.getName());
            } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
            Collections.reverse(qualifiedNameElements);
            return this.renderFqName(qualifiedNameElements);
        }
        return this.renderFqName(DescriptorUtils.getFQName(klass));
    }

    @Override
    @NotNull
    public String renderType(@NotNull JetType type) {
        return this.escape(this.renderTypeWithoutEscape(type));
    }

    private String renderTypeWithoutEscape(@NotNull JetType type) {
        if (type == ExpressionTypingUtils.CANT_INFER_LAMBDA_PARAM_TYPE || type == CallResolverUtil.CANT_INFER_TYPE_PARAMETER) {
            return "???";
        }
        if (ErrorUtils.isErrorType(type)) {
            return type.toString();
        }
        if (KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(type) && this.prettyFunctionTypes) {
            return this.renderFunctionType(type);
        }
        return this.renderDefaultType(type);
    }

    @NotNull
    private String renderDefaultType(@NotNull JetType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.renderTypeName(type.getConstructor()));
        if (!type.getArguments().isEmpty()) {
            sb.append("<");
            this.appendTypeProjections(type.getArguments(), sb);
            sb.append(">");
        }
        if (type.isNullable()) {
            sb.append("?");
        }
        return sb.toString();
    }

    @NotNull
    private String renderTypeName(@NotNull TypeConstructor typeConstructor) {
        ClassifierDescriptor cd = typeConstructor.getDeclarationDescriptor();
        if (cd instanceof TypeParameterDescriptor) {
            return this.renderName(cd.getName());
        }
        if (cd instanceof ClassDescriptor) {
            return this.renderClassName((ClassDescriptor)cd);
        }
        assert (cd == null) : "Unexpected classifier: " + cd.getClass();
        return typeConstructor.toString();
    }

    private void appendTypeProjections(@NotNull List<TypeProjection> typeProjections, @NotNull StringBuilder builder) {
        Iterator<TypeProjection> iterator = typeProjections.iterator();
        while (iterator.hasNext()) {
            TypeProjection typeProjection = iterator.next();
            if (typeProjection.getProjectionKind() != Variance.INVARIANT) {
                builder.append((Object)typeProjection.getProjectionKind()).append(" ");
            }
            builder.append(this.renderType(typeProjection.getType()));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
    }

    @NotNull
    private String renderFunctionType(@NotNull JetType type) {
        StringBuilder sb = new StringBuilder();
        JetType receiverType = KotlinBuiltIns.getInstance().getReceiverType(type);
        if (receiverType != null) {
            sb.append(this.renderType(receiverType));
            sb.append(".");
        }
        sb.append("(");
        this.appendTypeProjections(KotlinBuiltIns.getInstance().getParameterTypeProjectionsFromFunctionType(type), sb);
        sb.append(") " + this.arrow() + " ");
        sb.append(this.renderType(KotlinBuiltIns.getInstance().getReturnTypeFromFunctionType(type)));
        if (type.isNullable()) {
            return "(" + sb + ")?";
        }
        return sb.toString();
    }

    private void appendDefinedIn(@NotNull DeclarationDescriptor descriptor, @NotNull StringBuilder builder) {
        if (descriptor instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        builder.append(" ").append(this.renderMessage("defined in")).append(" ");
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration != null) {
            FqNameUnsafe fqName = DescriptorUtils.getFQName(containingDeclaration);
            builder.append(FqName.ROOT.equalsTo(fqName) ? "root package" : this.renderFqName(fqName));
        }
    }

    private void renderAnnotations(@NotNull Annotated annotated, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.ANNOTATIONS)) {
            return;
        }
        for (AnnotationDescriptor annotation : annotated.getAnnotations()) {
            ClassDescriptor annotationClass = (ClassDescriptor)annotation.getType().getConstructor().getDeclarationDescriptor();
            assert (annotationClass != null);
            if (this.excludedAnnotationClasses.contains(DescriptorUtils.getFQName(annotationClass).toSafe())) continue;
            builder.append(this.renderType(annotation.getType()));
            if (this.verbose) {
                builder.append("(").append(StringUtil.join(DescriptorUtils.getSortedValueArguments(annotation, this), ", ")).append(")");
            }
            builder.append(" ");
        }
    }

    private void renderVisibility(@NotNull Visibility visibility, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.VISIBILITY)) {
            return;
        }
        if (this.normalizedVisibilities) {
            visibility = visibility.normalize();
        }
        if (!this.showInternalKeyword && visibility == Visibilities.INTERNAL) {
            return;
        }
        builder.append(this.renderKeyword(visibility.toString())).append(" ");
    }

    private void renderModality(@NotNull Modality modality, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MODALITY)) {
            return;
        }
        String keyword = modality.name().toLowerCase();
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private void renderInner(boolean isInner, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.INNER)) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private void renderModalityForCallable(@NotNull CallableMemberDescriptor callable, @NotNull StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || callable.getModality() != Modality.FINAL) {
            if (this.overridesSomething(callable) && this.overrideRenderingPolicy == DescriptorRenderer.OverrideRenderingPolicy.RENDER_OVERRIDE && callable.getModality() == Modality.OPEN) {
                return;
            }
            this.renderModality(callable.getModality(), builder);
        }
    }

    private boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    private void renderOverride(@NotNull CallableMemberDescriptor callableMember, @NotNull StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMember) && this.overrideRenderingPolicy != DescriptorRenderer.OverrideRenderingPolicy.RENDER_OPEN) {
            builder.append("override ");
            if (this.verbose) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.modifiers.contains((Object)DescriptorRenderer.Modifier.MEMBER_KIND)) {
            return;
        }
        if (this.verbose && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            builder.append("/*").append(callableMember.getKind().name().toLowerCase()).append("*/ ");
        }
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), stringBuilder);
        if (this.withDefinedIn) {
            this.appendDefinedIn(declarationDescriptor, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void renderTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull StringBuilder builder, boolean topLevel) {
        String variance;
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.verbose) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        if (!(variance = typeParameter.getVariance().toString()).isEmpty()) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderName(typeParameter, builder);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            JetType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!((Object)KotlinBuiltIns.getInstance().getDefaultBound()).equals(upperBound) || this.alwaysRenderAny) {
                builder.append(" : ").append(this.renderType(upperBound));
            }
        } else if (topLevel) {
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (((Object)upperBound).equals(KotlinBuiltIns.getInstance().getDefaultBound())) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                builder.append(this.renderType(upperBound));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(">");
        }
    }

    private void renderTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder, boolean withSpace) {
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            Iterator<TypeParameterDescriptor> iterator = typeParameters.iterator();
            while (iterator.hasNext()) {
                TypeParameterDescriptor typeParameterDescriptor = iterator.next();
                this.renderTypeParameter(typeParameterDescriptor, builder, false);
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(">");
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private void renderFunction(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        if (!this.startFromName) {
            this.renderAnnotations(function, builder);
            this.renderVisibility(function.getVisibility(), builder);
            this.renderModalityForCallable(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            builder.append(this.renderKeyword("fun")).append(" ");
            this.renderTypeParameters(function.getTypeParameters(), builder, true);
            ReceiverParameterDescriptor receiver = function.getReceiverParameter();
            if (receiver != null) {
                builder.append(this.escape(this.renderType(receiver.getType()))).append(".");
            }
        }
        this.renderName(function, builder);
        this.renderValueParameters(function, builder);
        JetType returnType = function.getReturnType();
        if (this.unitReturnType || !KotlinBuiltIns.getInstance().isUnit(returnType)) {
            builder.append(": ").append(returnType == null ? "[NULL]" : this.escape(this.renderType(returnType)));
        }
        this.renderWhereSuffix(function.getTypeParameters(), builder);
    }

    private void renderConstructor(@NotNull ConstructorDescriptor constructor, @NotNull StringBuilder builder) {
        this.renderAnnotations(constructor, builder);
        this.renderVisibility(constructor.getVisibility(), builder);
        this.renderMemberKind(constructor, builder);
        builder.append(this.renderKeyword("constructor")).append(" ");
        ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
        this.renderName(classDescriptor, builder);
        this.renderTypeParameters(classDescriptor.getTypeConstructor().getParameters(), builder, false);
        this.renderValueParameters(constructor, builder);
        this.renderWhereSuffix(constructor.getTypeParameters(), builder);
    }

    private void renderWhereSuffix(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull StringBuilder builder) {
        ArrayList<String> upperBoundStrings = Lists.newArrayList();
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            if (typeParameter.getUpperBounds().size() <= 1) continue;
            boolean first = true;
            for (JetType upperBound : typeParameter.getUpperBounds()) {
                if (!first) {
                    upperBoundStrings.add(this.renderName(typeParameter.getName()) + " : " + this.escape(this.renderType(upperBound)));
                }
                first = false;
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            builder.append(StringUtil.join(upperBoundStrings, ", "));
        }
    }

    @Override
    @NotNull
    public String renderFunctionParameters(@NotNull FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        this.renderValueParameters(functionDescriptor, stringBuilder);
        return stringBuilder.toString();
    }

    private void renderValueParameters(@NotNull FunctionDescriptor function, @NotNull StringBuilder builder) {
        this.handler.appendBeforeValueParameters(function, builder);
        for (ValueParameterDescriptor parameter : function.getValueParameters()) {
            this.handler.appendBeforeValueParameter(parameter, builder);
            this.renderValueParameter(parameter, builder, false);
            this.handler.appendAfterValueParameter(parameter, builder);
        }
        this.handler.appendAfterValueParameters(function, builder);
    }

    private void renderValueParameter(@NotNull ValueParameterDescriptor valueParameter, @NotNull StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.verbose) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        this.renderVariable(valueParameter, builder, topLevel);
        boolean bl = withDefaultValue = this.debugMode ? valueParameter.declaresDefaultValue() : valueParameter.hasDefaultValue();
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private void renderValVarPrefix(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder) {
        builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
    }

    private void renderVariable(@NotNull VariableDescriptor variable, @NotNull StringBuilder builder, boolean topLevel) {
        JetType typeToRender;
        JetType realType = variable.getType();
        JetType varargElementType = variable instanceof ValueParameterDescriptor ? ((ValueParameterDescriptor)variable).getVarargElementType() : null;
        JetType jetType = typeToRender = varargElementType != null ? varargElementType : realType;
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.startFromName) {
            this.renderValVarPrefix(variable, builder);
        }
        this.renderName(variable, builder);
        builder.append(": ").append(this.escape(this.renderType(typeToRender)));
        if (this.verbose && varargElementType != null) {
            builder.append(" /*").append(this.escape(this.renderType(realType))).append("*/");
        }
    }

    private void renderProperty(@NotNull PropertyDescriptor property, @NotNull StringBuilder builder) {
        if (!this.startFromName) {
            this.renderAnnotations(property, builder);
            this.renderVisibility(property.getVisibility(), builder);
            this.renderModalityForCallable(property, builder);
            this.renderOverride(property, builder);
            this.renderMemberKind(property, builder);
            this.renderValVarPrefix(property, builder);
        }
        this.renderTypeParameters(property.getTypeParameters(), builder, true);
        ReceiverParameterDescriptor receiver = property.getReceiverParameter();
        if (receiver != null) {
            builder.append(this.escape(this.renderType(receiver.getType()))).append(".");
        }
        this.renderName(property, builder);
        builder.append(": ").append(this.escape(this.renderType(property.getType())));
        this.renderWhereSuffix(property.getTypeParameters(), builder);
    }

    private void renderClass(@NotNull ClassDescriptor klass, @NotNull StringBuilder builder) {
        Collection<JetType> supertypes;
        ConstructorDescriptor primaryConstructor;
        if (!this.startFromName) {
            this.renderAnnotations(klass, builder);
            this.renderVisibility(klass.getVisibility(), builder);
            if (!(klass.getKind() == ClassKind.TRAIT && klass.getModality() == Modality.ABSTRACT || klass.getKind().isObject() && klass.getModality() == Modality.FINAL)) {
                this.renderModality(klass.getModality(), builder);
            }
            this.renderInner(klass.isInner(), builder);
            builder.append(this.renderKeyword(DescriptorRendererImpl.getClassKindPrefix(klass)));
        }
        if (klass.getKind() != ClassKind.CLASS_OBJECT || this.verbose) {
            builder.append(" ");
            this.renderName(klass, builder);
        }
        List<TypeParameterDescriptor> typeParameters = klass.getTypeConstructor().getParameters();
        this.renderTypeParameters(typeParameters, builder, false);
        if (!klass.getKind().isObject() && this.classWithPrimaryConstructor && (primaryConstructor = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            this.renderValueParameters(primaryConstructor, builder);
        }
        if (!(klass.equals(KotlinBuiltIns.getInstance().getNothing()) || (supertypes = klass.getTypeConstructor().getSupertypes()).isEmpty() || !this.alwaysRenderAny && supertypes.size() == 1 && KotlinBuiltIns.getInstance().isAny(supertypes.iterator().next()))) {
            builder.append(" : ");
            Iterator<JetType> iterator = supertypes.iterator();
            while (iterator.hasNext()) {
                JetType supertype = iterator.next();
                builder.append(this.renderType(supertype));
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        this.renderWhereSuffix(typeParameters, builder);
    }

    @NotNull
    private static String getClassKindPrefix(@NotNull ClassDescriptor klass) {
        switch (klass.getKind()) {
            case CLASS: {
                return "class";
            }
            case TRAIT: {
                return "trait";
            }
            case ENUM_CLASS: {
                return "enum class";
            }
            case OBJECT: {
                return "object";
            }
            case ANNOTATION_CLASS: {
                return "annotation class";
            }
            case CLASS_OBJECT: {
                return "class object";
            }
            case ENUM_ENTRY: {
                return "enum entry";
            }
        }
        throw new IllegalStateException("unknown class kind: " + (Object)((Object)klass.getKind()));
    }

    private void renderModuleOrScript(@NotNull DeclarationDescriptor moduleOrScript, @NotNull StringBuilder builder) {
        this.renderName(moduleOrScript, builder);
    }

    private void renderNamespace(@NotNull NamespaceDescriptor namespace, @NotNull StringBuilder builder) {
        builder.append(this.renderKeyword(JetTokens.PACKAGE_KEYWORD.getValue())).append(" ");
        this.renderName(namespace, builder);
    }

    static {
        for (IElementType elementType : JetTokens.KEYWORDS.getTypes()) {
            assert (elementType instanceof JetKeywordToken);
            assert (!((JetKeywordToken)elementType).isSoft());
            KEYWORDS.add(((JetKeywordToken)elementType).getValue());
        }
    }

    private class RenderDeclarationDescriptorVisitor
    extends DeclarationDescriptorVisitorEmptyBodies<Void, StringBuilder> {
        private RenderDeclarationDescriptorVisitor() {
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderValueParameter(descriptor, builder, true);
            return null;
        }

        @Override
        public Void visitVariableDescriptor(VariableDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderVariable(descriptor, builder, true);
            return null;
        }

        @Override
        public Void visitPropertyDescriptor(PropertyDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderProperty(descriptor, builder);
            return null;
        }

        @Override
        public Void visitFunctionDescriptor(FunctionDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderFunction(descriptor, builder);
            return null;
        }

        @Override
        public Void visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor, StringBuilder data) {
            throw new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public Void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
            return null;
        }

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderTypeParameter(descriptor, builder, true);
            return null;
        }

        @Override
        public Void visitNamespaceDescriptor(NamespaceDescriptor namespaceDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderNamespace(namespaceDescriptor, builder);
            return null;
        }

        @Override
        public Void visitModuleDeclaration(ModuleDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(descriptor, builder);
            return null;
        }

        @Override
        public Void visitScriptDescriptor(ScriptDescriptor scriptDescriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderModuleOrScript(scriptDescriptor, builder);
            return null;
        }

        @Override
        public Void visitClassDescriptor(ClassDescriptor descriptor, StringBuilder builder) {
            DescriptorRendererImpl.this.renderClass(descriptor, builder);
            return null;
        }
    }
}

