/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.general;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public class JetTestFunctionDetector {
    private JetTestFunctionDetector() {
    }

    private static boolean isTest(@NotNull BindingContext bindingContext, @NotNull JetNamedFunction function) {
        SimpleFunctionDescriptor functionDescriptor = BindingUtils.getNullableDescriptorForFunction(bindingContext, function);
        if (functionDescriptor == null) {
            return false;
        }
        List<AnnotationDescriptor> annotations = functionDescriptor.getAnnotations();
        if (annotations != null) {
            for (AnnotationDescriptor annotation : annotations) {
                JetType type = annotation.getType();
                String name = type.toString();
                if (!name.equals("Test")) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static List<JetNamedFunction> findTestFunctions(@NotNull BindingContext bindingContext, @NotNull Collection<JetFile> files) {
        ArrayList<JetNamedFunction> answer = Lists.newArrayList();
        for (JetFile file : files) {
            answer.addAll(JetTestFunctionDetector.getTestFunctions(bindingContext, file.getDeclarations()));
        }
        return answer;
    }

    @NotNull
    public static List<FunctionDescriptor> getTestFunctionDescriptors(@NotNull BindingContext bindingContext, @NotNull Collection<JetFile> files) {
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        for (JetNamedFunction function : JetTestFunctionDetector.findTestFunctions(bindingContext, files)) {
            answer.add(BindingUtils.getFunctionDescriptor(bindingContext, function));
        }
        return answer;
    }

    @NotNull
    private static List<JetNamedFunction> getTestFunctions(@NotNull BindingContext bindingContext, @NotNull List<JetDeclaration> declarations) {
        ArrayList<JetNamedFunction> answer = Lists.newArrayList();
        for (JetDeclaration declaration : declarations) {
            JetNamedFunction candidateFunction;
            if (declaration instanceof JetClass) {
                JetClass klass = (JetClass)declaration;
                answer.addAll(JetTestFunctionDetector.getTestFunctions(bindingContext, klass.getDeclarations()));
                continue;
            }
            if (!(declaration instanceof JetNamedFunction) || !JetTestFunctionDetector.isTest(bindingContext, candidateFunction = (JetNamedFunction)declaration)) continue;
            answer.add(candidateFunction);
        }
        return answer;
    }
}

