/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.general;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.plugin.JetMainDetector;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.facade.MainCallParameters;
import org.jetbrains.k2js.facade.exceptions.MainFunctionNotFoundException;
import org.jetbrains.k2js.facade.exceptions.TranslationException;
import org.jetbrains.k2js.facade.exceptions.TranslationInternalException;
import org.jetbrains.k2js.facade.exceptions.UnsupportedFeatureException;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.StaticContext;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.NamespaceDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.ExpressionVisitor;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.expression.PatternTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.test.JSTestGenerator;
import org.jetbrains.k2js.translate.test.JSTester;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousTranslator;

public final class Translation {
    private Translation() {
    }

    @NotNull
    public static FunctionTranslator functionTranslator(@NotNull JetDeclarationWithBody function, @NotNull TranslationContext context) {
        return FunctionTranslator.newInstance(function, context);
    }

    @NotNull
    public static PatternTranslator patternTranslator(@NotNull TranslationContext context) {
        return PatternTranslator.newInstance(context);
    }

    @NotNull
    public static JsNode translateExpression(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        JsName aliasForExpression = context.aliasingContext().getAliasForExpression(expression);
        if (aliasForExpression != null) {
            return aliasForExpression.makeRef();
        }
        DangerousData data = DangerousData.collect(expression, context);
        if (data.shouldBeTranslated()) {
            return DangerousTranslator.translate(data, context);
        }
        return Translation.doTranslateExpression(expression, context);
    }

    @NotNull
    public static JsNode doTranslateExpression(JetExpression expression, TranslationContext context) {
        return expression.accept(new ExpressionVisitor(), context);
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        return JsAstUtils.convertToExpression(Translation.translateExpression(expression, context));
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        return JsAstUtils.convertToStatement(Translation.translateExpression(expression, context));
    }

    @NotNull
    public static JsProgram generateAst(@NotNull BindingContext bindingContext, @NotNull Collection<JetFile> files, @NotNull MainCallParameters mainCallParameters, @NotNull Config config) throws TranslationException {
        try {
            return Translation.doGenerateAst(bindingContext, files, mainCallParameters, config);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFeatureException("Unsupported feature used.", e);
        }
        catch (Throwable e) {
            throw new TranslationInternalException(e);
        }
    }

    @NotNull
    private static JsProgram doGenerateAst(@NotNull BindingContext bindingContext, @NotNull Collection<JetFile> files, @NotNull MainCallParameters mainCallParameters, @NotNull Config config) throws MainFunctionNotFoundException {
        JsStatement statement;
        StaticContext staticContext = StaticContext.generateStaticContext(bindingContext, config.getTarget());
        JsProgram program = staticContext.getProgram();
        JsBlock block = program.getGlobalBlock();
        JsFunction rootFunction = JsAstUtils.createPackage(block.getStatements(), program.getScope());
        JsBlock rootBlock = rootFunction.getBody();
        List<JsStatement> statements = rootBlock.getStatements();
        statements.add(program.getStringLiteral("use strict").makeStmt());
        TranslationContext context = TranslationContext.rootContext(staticContext, rootFunction);
        staticContext.initTranslators(context);
        statements.addAll(NamespaceDeclarationTranslator.translateFiles(files, context));
        Translation.defineModule(context, statements, config.getModuleId());
        if (mainCallParameters.shouldBeGenerated() && (statement = Translation.generateCallToMain(context, files, mainCallParameters.arguments())) != null) {
            statements.add(statement);
        }
        Translation.mayBeGenerateTests(files, config, rootBlock, context);
        return context.program();
    }

    private static void defineModule(@NotNull TranslationContext context, @NotNull List<JsStatement> statements, @NotNull String moduleId) {
        JsName rootNamespaceName = context.scope().findName(Namer.getRootNamespaceName());
        if (rootNamespaceName != null) {
            statements.add(new JsInvocation(context.namer().kotlin("defineModule"), context.program().getStringLiteral(moduleId), rootNamespaceName.makeRef()).makeStmt());
        }
    }

    private static void mayBeGenerateTests(@NotNull Collection<JetFile> files, @NotNull Config config, @NotNull JsBlock rootBlock, @NotNull TranslationContext context) {
        JSTester tester = config.getTester();
        if (tester != null) {
            tester.initialize(context, rootBlock);
            JSTestGenerator.generateTestCalls(context, files, tester);
            tester.deinitialize();
        }
    }

    @Nullable
    private static JsStatement generateCallToMain(@NotNull TranslationContext context, @NotNull Collection<JetFile> files, @NotNull List<String> arguments) throws MainFunctionNotFoundException {
        JetNamedFunction mainFunction = JetMainDetector.getMainFunction(files);
        if (mainFunction == null) {
            return null;
        }
        JsInvocation translatedCall = Translation.generateInvocation(context, mainFunction);
        Translation.setArguments(context, arguments, translatedCall);
        return translatedCall.makeStmt();
    }

    @NotNull
    private static JsInvocation generateInvocation(@NotNull TranslationContext context, @NotNull JetNamedFunction mainFunction) {
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), mainFunction);
        JsExpression translatedCall = CallBuilder.build(context).descriptor(functionDescriptor).translate();
        assert (translatedCall instanceof JsInvocation);
        return (JsInvocation)translatedCall;
    }

    private static void setArguments(@NotNull TranslationContext context, @NotNull List<String> arguments, @NotNull JsInvocation translatedCall) {
        JsArrayLiteral arrayLiteral = new JsArrayLiteral(JsAstUtils.toStringLiteralList(arguments, context.program()));
        JsAstUtils.setArguments(translatedCall, Collections.singletonList(arrayLiteral));
    }
}

