/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CallTranslator;
import org.jetbrains.k2js.translate.reference.CallType;

public final class CallBuilder {
    @NotNull
    private final TranslationContext context;
    @Nullable
    private JsExpression receiver = null;
    @NotNull
    private final List<JsExpression> args = Lists.newArrayList();
    @NotNull
    private CallType callType = CallType.NORMAL;
    @Nullable
    private ResolvedCall<?> resolvedCall = null;
    @Nullable
    private CallableDescriptor descriptor = null;
    @Nullable
    private JsExpression callee = null;

    public static CallBuilder build(@NotNull TranslationContext context) {
        return new CallBuilder(context);
    }

    private CallBuilder(@NotNull TranslationContext context) {
        this.context = context;
    }

    @NotNull
    public CallBuilder receiver(@Nullable JsExpression receiver) {
        this.receiver = receiver;
        return this;
    }

    @NotNull
    public CallBuilder args(@NotNull List<JsExpression> args) {
        assert (this.args.isEmpty());
        this.args.addAll(args);
        return this;
    }

    @NotNull
    public CallBuilder args(JsExpression ... args) {
        return this.args(Arrays.asList(args));
    }

    @NotNull
    public CallBuilder descriptor(@NotNull CallableDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @NotNull
    public CallBuilder callee(@Nullable JsExpression callee) {
        this.callee = callee;
        return this;
    }

    @NotNull
    public CallBuilder resolvedCall(@NotNull ResolvedCall<?> call) {
        this.resolvedCall = call;
        return this;
    }

    @NotNull
    public CallBuilder type(@NotNull CallType type) {
        this.callType = type;
        return this;
    }

    @NotNull
    private CallTranslator finish() {
        if (this.resolvedCall == null) {
            assert (this.descriptor != null);
            this.resolvedCall = ResolvedCallImpl.create(ResolutionCandidate.create(this.descriptor, DescriptorUtils.safeGetValue(this.descriptor.getExpectedThisObject()), DescriptorUtils.safeGetValue(this.descriptor.getReceiverParameter()), ExplicitReceiverKind.THIS_OBJECT, false), TemporaryBindingTrace.create(new BindingTraceContext(), "trace to resolve call (in js)"), TracingStrategy.EMPTY, MutableDataFlowInfoForArguments.WITHOUT_ARGUMENTS_CHECK);
        }
        if (this.descriptor == null) {
            this.descriptor = this.resolvedCall.getCandidateDescriptor().getOriginal();
        }
        assert (this.resolvedCall != null);
        return new CallTranslator(this.receiver, this.callee, this.args, this.resolvedCall, this.descriptor, this.callType, this.context);
    }

    @NotNull
    public JsExpression translate() {
        return this.finish().translate();
    }
}

