/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PredefinedAnnotation;

public final class AnnotationsUtils {
    private AnnotationsUtils() {
    }

    private static boolean hasAnnotation(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        return AnnotationsUtils.getAnnotationByName(descriptor, annotation) != null;
    }

    @Nullable
    private static String getAnnotationStringParameter(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation) {
        AnnotationDescriptor annotationDescriptor = AnnotationsUtils.getAnnotationByName(declarationDescriptor, annotation);
        assert (annotationDescriptor != null);
        if (annotationDescriptor.getAllValueArguments().isEmpty()) {
            return null;
        }
        CompileTimeConstant<?> constant = annotationDescriptor.getAllValueArguments().values().iterator().next();
        if (constant == null) {
            return null;
        }
        Object value = constant.getValue();
        assert (value instanceof String) : "Native function annotation should have one String parameter";
        return (String)value;
    }

    @Nullable
    public static String getNameForAnnotatedObject(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull PredefinedAnnotation annotation) {
        if (!AnnotationsUtils.hasAnnotation(declarationDescriptor, annotation)) {
            return null;
        }
        return AnnotationsUtils.getAnnotationStringParameter(declarationDescriptor, annotation);
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        return AnnotationsUtils.getAnnotationByName(descriptor, annotation.getFQName());
    }

    @Nullable
    private static AnnotationDescriptor getAnnotationByName(@NotNull DeclarationDescriptor descriptor, @NotNull String fqn) {
        for (AnnotationDescriptor annotationDescriptor : descriptor.getAnnotations()) {
            if (!AnnotationsUtils.getAnnotationClassFQName(annotationDescriptor).equals(fqn)) continue;
            return annotationDescriptor;
        }
        return null;
    }

    @NotNull
    private static String getAnnotationClassFQName(@NotNull AnnotationDescriptor annotationDescriptor) {
        ClassifierDescriptor annotationDeclaration = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        assert (annotationDeclaration != null) : "Annotation supposed to have a declaration";
        return DescriptorUtils.getFQName(annotationDeclaration).asString();
    }

    public static boolean isNativeObject(@NotNull DeclarationDescriptor descriptor) {
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.NATIVE);
    }

    public static boolean isEnumerable(@NotNull DeclarationDescriptor descriptor) {
        if (AnnotationsUtils.getAnnotationByName(descriptor, "js.enumerable") != null) {
            return true;
        }
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
        return containingClass != null && (containingClass.getKind().equals((Object)ClassKind.OBJECT) && containingClass.getName().isSpecial() || AnnotationsUtils.getAnnotationByName((DeclarationDescriptor)containingClass, "js.enumerable") != null);
    }

    public static boolean isLibraryObject(@NotNull DeclarationDescriptor descriptor) {
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, PredefinedAnnotation.LIBRARY);
    }

    public static boolean isPredefinedObject(@NotNull DeclarationDescriptor descriptor) {
        for (PredefinedAnnotation annotation : PredefinedAnnotation.values()) {
            if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull PredefinedAnnotation annotation) {
        return AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation.getFQName());
    }

    private static boolean hasAnnotationOrInsideAnnotatedClass(@NotNull DeclarationDescriptor descriptor, @NotNull String fqn) {
        if (AnnotationsUtils.getAnnotationByName(descriptor, fqn) != null) {
            return true;
        }
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
        return containingClass != null && AnnotationsUtils.getAnnotationByName((DeclarationDescriptor)containingClass, fqn) != null;
    }
}

