/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorForObject;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class BindingUtils {
    private BindingUtils() {
    }

    @NotNull
    private static <E extends PsiElement, D extends DeclarationDescriptor> D getDescriptorForExpression(@NotNull BindingContext context, @NotNull E expression, Class<D> descriptorClass) {
        DeclarationDescriptor descriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression);
        assert (descriptor != null);
        assert (descriptorClass.isInstance(descriptor)) : ErrorReportingUtils.message(expression, ((Object)expression).toString() + " expected to have of type" + descriptorClass.toString());
        return (D)descriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptor(@NotNull BindingContext context, @NotNull JetClassOrObject declaration) {
        return BindingContextUtils.getNotNull(context, BindingContext.CLASS, declaration);
    }

    @NotNull
    public static FunctionDescriptor getFunctionDescriptor(@NotNull BindingContext context, @NotNull JetDeclarationWithBody declaration) {
        return BindingUtils.getDescriptorForExpression(context, declaration, FunctionDescriptor.class);
    }

    @NotNull
    public static PropertyDescriptor getPropertyDescriptor(@NotNull BindingContext context, @NotNull JetProperty declaration) {
        return BindingUtils.getDescriptorForExpression(context, declaration, PropertyDescriptor.class);
    }

    @NotNull
    public static JetFunction getFunctionForDescriptor(@NotNull BindingContext context, @NotNull SimpleFunctionDescriptor descriptor) {
        PsiElement result = BindingContextUtils.callableDescriptorToDeclaration(context, descriptor);
        assert (result instanceof JetFunction) : ErrorReportingUtils.message(context, descriptor, "SimpleFunctionDescriptor should have declaration of type JetFunction");
        return (JetFunction)result;
    }

    @NotNull
    private static JetParameter getParameterForDescriptor(@NotNull BindingContext context, @NotNull ValueParameterDescriptor descriptor) {
        PsiElement result = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        assert (result instanceof JetParameter) : ErrorReportingUtils.message(context, descriptor, "ValueParameterDescriptor should have corresponding JetParameter");
        return (JetParameter)result;
    }

    public static boolean hasAncestorClass(@NotNull BindingContext context, @NotNull JetClassOrObject classDeclaration) {
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context, classDeclaration);
        List<ClassDescriptor> superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor);
        return JsDescriptorUtils.findAncestorClass(superclassDescriptors) != null;
    }

    public static boolean isStatement(@NotNull BindingContext context, @NotNull JetExpression expression) {
        return BindingContextUtils.getNotNull(context, BindingContext.STATEMENT, expression);
    }

    @NotNull
    public static JetType getTypeByReference(@NotNull BindingContext context, @NotNull JetTypeReference typeReference) {
        return BindingContextUtils.getNotNull(context, BindingContext.TYPE, typeReference);
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeReference(@NotNull BindingContext context, @NotNull JetTypeReference typeReference) {
        return DescriptorUtils.getClassDescriptorForType(BindingUtils.getTypeByReference(context, typeReference));
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorForConstructorParameter(@NotNull BindingContext context, @NotNull JetParameter parameter) {
        return context.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
    }

    @Nullable
    public static DeclarationDescriptor getDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull JetReferenceExpression reference) {
        if (BindingContextUtils.isExpressionWithValidReference(reference, context)) {
            return BindingContextUtils.getNotNull(context, BindingContext.REFERENCE_TARGET, reference);
        }
        return null;
    }

    @Nullable
    public static DeclarationDescriptor getNullableDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull JetReferenceExpression reference) {
        return context.get(BindingContext.REFERENCE_TARGET, reference);
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCall(@NotNull BindingContext context, @NotNull JetExpression expression) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = context.get(BindingContext.RESOLVED_CALL, expression);
        assert (resolvedCall != null) : ErrorReportingUtils.message(expression, expression.getText() + " must resolve to a call");
        return resolvedCall;
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCallForProperty(@NotNull BindingContext context, @NotNull JetExpression expression) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = context.get(BindingContext.RESOLVED_CALL, expression);
        assert (resolvedCall != null) : ErrorReportingUtils.message(expression, expression.getText() + "must resolve to a call");
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall();
        }
        return resolvedCall;
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCallForCallExpression(@NotNull BindingContext context, @NotNull JetCallExpression expression) {
        JetExpression calleeExpression = PsiUtils.getCallee(expression);
        return BindingUtils.getResolvedCall(context, calleeExpression);
    }

    public static boolean isVariableReassignment(@NotNull BindingContext context, @NotNull JetExpression expression) {
        return BindingContextUtils.getNotNull(context, BindingContext.VARIABLE_REASSIGNMENT, expression);
    }

    @Nullable
    public static FunctionDescriptor getFunctionDescriptorForOperationExpression(@NotNull BindingContext context, @NotNull JetOperationExpression expression) {
        DeclarationDescriptor descriptorForReferenceExpression = BindingUtils.getNullableDescriptorForReferenceExpression(context, expression.getOperationReference());
        if (descriptorForReferenceExpression == null) {
            return null;
        }
        assert (descriptorForReferenceExpression instanceof FunctionDescriptor) : ErrorReportingUtils.message(expression.getOperationReference(), "Operation should resolve to function descriptor");
        return (FunctionDescriptor)descriptorForReferenceExpression;
    }

    @NotNull
    public static DeclarationDescriptor getDescriptorForElement(@NotNull BindingContext context, @NotNull PsiElement element) {
        return BindingContextUtils.getNotNull(context, BindingContext.DECLARATION_TO_DESCRIPTOR, element);
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context, @NotNull JetExpression expression) {
        CompileTimeConstant<?> compileTimeValue = context.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeValue != null) {
            return compileTimeValue.getValue();
        }
        return null;
    }

    @NotNull
    public static JetExpression getDefaultArgument(@NotNull BindingContext context, @NotNull ValueParameterDescriptor parameterDescriptor) {
        ValueParameterDescriptor descriptorWhichDeclaresDefaultValue = BindingUtils.getOriginalDescriptorWhichDeclaresDefaultValue(context, parameterDescriptor);
        JetParameter psiParameter = BindingUtils.getParameterForDescriptor(context, descriptorWhichDeclaresDefaultValue);
        JetExpression defaultValue = psiParameter.getDefaultValue();
        assert (defaultValue != null) : ErrorReportingUtils.message(context, parameterDescriptor, "No default value found in PSI");
        return defaultValue;
    }

    private static ValueParameterDescriptor getOriginalDescriptorWhichDeclaresDefaultValue(BindingContext context, @NotNull ValueParameterDescriptor parameterDescriptor) {
        ValueParameterDescriptor result = parameterDescriptor;
        assert (result.hasDefaultValue()) : ErrorReportingUtils.message(context, parameterDescriptor, "Unsupplied parameter must have default value");
        while (!result.declaresDefaultValue()) {
            result = result.getOverriddenDescriptors().iterator().next();
        }
        return result;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getIteratorFunction(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        return BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, rangeExpression);
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getNextFunction(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        return BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, rangeExpression);
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getHasNextCallable(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        return BindingContextUtils.getNotNull(context, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, rangeExpression);
    }

    @NotNull
    public static JetType getTypeForExpression(@NotNull BindingContext context, @NotNull JetExpression expression) {
        return BindingContextUtils.getNotNull(context, BindingContext.EXPRESSION_TYPE, expression);
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getResolvedCallForArrayAccess(@NotNull BindingContext context, @NotNull JetArrayAccessExpression arrayAccessExpression, boolean isGet) {
        return BindingContextUtils.getNotNull(context, isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression);
    }

    public static ConstructorDescriptor getConstructor(@NotNull BindingContext bindingContext, @NotNull JetClassOrObject declaration) {
        ConstructorDescriptor primaryConstructor = BindingUtils.getClassDescriptor(bindingContext, declaration).getUnsubstitutedPrimaryConstructor();
        assert (primaryConstructor != null) : ErrorReportingUtils.message(declaration, "Traits do not have initialize methods");
        return primaryConstructor;
    }

    @Nullable
    public static SimpleFunctionDescriptor getNullableDescriptorForFunction(@NotNull BindingContext bindingContext, @NotNull JetNamedFunction function) {
        return bindingContext.get(BindingContext.FUNCTION, function);
    }

    public static boolean isObjectDeclaration(@NotNull PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor instanceof VariableDescriptorForObject;
    }
}

