/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;

public class JsFor
extends SourceInfoAwareJsNode
implements JsStatement {
    private JsStatement body;
    private JsExpression condition;
    private JsExpression incrementExpression;
    private JsExpression initExpression;
    private JsVars initVars;

    public JsFor(JsVars initVars, JsExpression condition, JsExpression incrementExpression) {
        this(initVars, condition, incrementExpression, null);
    }

    public JsFor(JsVars initVars, JsExpression condition, JsExpression incrementExpression, JsStatement body) {
        this.initVars = initVars;
        this.incrementExpression = incrementExpression;
        this.condition = condition;
        this.body = body;
        this.initExpression = null;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getCondition() {
        return this.condition;
    }

    public JsExpression getIncrementExpression() {
        return this.incrementExpression;
    }

    public JsExpression getInitExpression() {
        return this.initExpression;
    }

    public JsVars getInitVars() {
        return this.initVars;
    }

    public void setBody(JsStatement body) {
        this.body = body;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFor(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor) {
        assert (this.initExpression == null || this.initVars == null);
        if (this.initExpression != null) {
            visitor.accept(this.initExpression);
        } else if (this.initVars != null) {
            visitor.accept(this.initVars);
        }
        if (this.condition != null) {
            visitor.accept(this.condition);
        }
        if (this.incrementExpression != null) {
            visitor.accept(this.incrementExpression);
        }
        visitor.accept(this.body);
    }
}

