/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class NullableNotNullManager {
    private static final Logger LOG = Logger.getInstance("#" + NullableNotNullManager.class.getName());
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList();
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList();
    public static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "edu.umd.cs.findbugs.annotations.Nullable"};
    public static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull"};

    public NullableNotNullManager() {
        Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
        Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    @Nullable
    public String getNullable(PsiModifierListOwner owner) {
        for (String nullable : this.getNullables()) {
            if (!AnnotationUtil.isAnnotated(owner, nullable, false, false)) continue;
            return nullable;
        }
        return null;
    }

    @Nullable
    public String getNotNull(PsiModifierListOwner owner) {
        for (String notNull : this.getNotNulls()) {
            if (!AnnotationUtil.isAnnotated(owner, notNull, false, false)) continue;
            return notNull;
        }
        return null;
    }

    public List<String> getNullables() {
        return this.myNullables;
    }

    public List<String> getNotNulls() {
        return this.myNotNulls;
    }
}

