/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.concurrency.JobLauncher;
import com.intellij.core.CoreASTFactory;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockReferenceProvidersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.impl.CoreVirtualFilePointerManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiReferenceServiceImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Function;
import com.intellij.util.messages.impl.MessageBusImpl;
import org.picocontainer.MutablePicoContainer;

public class CoreApplicationEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    private final CoreEncodingRegistry myEncodingRegistry;
    protected final MockApplication myApplication;
    private final CoreLocalFileSystem myLocalFileSystem;
    protected final VirtualFileSystem myJarFileSystem;
    private final Disposable myParentDisposable;

    public CoreApplicationEnvironment(Disposable parentDisposable) {
        this.myParentDisposable = parentDisposable;
        Extensions.cleanRootArea(this.myParentDisposable);
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myEncodingRegistry = new CoreEncodingRegistry();
        this.myApplication = this.createApplication(this.myParentDisposable);
        ApplicationManager.setApplication(this.myApplication, new StaticGetter<FileTypeRegistry>(this.myFileTypeRegistry), new StaticGetter<EncodingRegistry>(this.myEncodingRegistry), this.myParentDisposable);
        this.myLocalFileSystem = this.createLocalFileSystem();
        this.myJarFileSystem = this.createJarFileSystem();
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        MutablePicoContainer appContainer = this.myApplication.getPicoContainer();
        CoreApplicationEnvironment.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(new Function<CharSequence, Document>(){

            @Override
            public Document fun(CharSequence charSequence) {
                return new DocumentImpl(charSequence);
            }
        }, null));
        VirtualFileSystem[] fs = new VirtualFileSystem[]{this.myLocalFileSystem, this.myJarFileSystem};
        VirtualFileManagerImpl virtualFileManager = new VirtualFileManagerImpl(fs, new MessageBusImpl(this.myApplication, null));
        CoreApplicationEnvironment.registerComponentInstance(appContainer, VirtualFileManager.class, virtualFileManager);
        this.registerApplicationService(VirtualFilePointerManager.class, this.createVirtualFilePointerManager());
        this.myApplication.registerService(DefaultASTFactory.class, new CoreASTFactory());
        this.myApplication.registerService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.myApplication.registerService(ReferenceProvidersRegistry.class, new MockReferenceProvidersRegistry());
        this.myApplication.registerService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.myApplication.registerService(PsiReferenceService.class, new PsiReferenceServiceImpl());
        this.myApplication.registerService(MetaDataRegistrar.class, new MetaRegistry());
        CoreApplicationEnvironment.registerApplicationExtensionPoint(ContentBasedFileSubstitutor.EP_NAME, ContentBasedFileSubstitutor.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), "com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), FileContextProvider.EP_NAME, FileContextProvider.class);
        CoreApplicationEnvironment.registerApplicationExtensionPoint(MetaDataContributor.EP_NAME, MetaDataContributor.class);
        ProgressIndicatorProvider.ourInstance = this.createProgressIndicatorProvider();
        this.myApplication.registerService(JobLauncher.class, this.createJobLauncher());
    }

    public <T> void registerApplicationService(Class<T> serviceInterface, T serviceImplementation) {
        this.myApplication.registerService(serviceInterface, serviceImplementation);
    }

    protected VirtualFilePointerManager createVirtualFilePointerManager() {
        return new CoreVirtualFilePointerManager();
    }

    protected MockApplication createApplication(Disposable parentDisposable) {
        return new MockApplication(parentDisposable);
    }

    protected JobLauncher createJobLauncher() {
        return new JobLauncher(){};
    }

    protected ProgressIndicatorProvider createProgressIndicatorProvider() {
        return new ProgressIndicatorProvider(){

            @Override
            public ProgressIndicator getProgressIndicator() {
                return new EmptyProgressIndicator();
            }

            @Override
            protected void doCheckCanceled() throws ProcessCanceledException {
            }

            @Override
            public NonCancelableSection startNonCancelableSection() {
                return NonCancelableSection.EMPTY;
            }
        };
    }

    protected VirtualFileSystem createJarFileSystem() {
        return new CoreJarFileSystem();
    }

    protected CoreLocalFileSystem createLocalFileSystem() {
        return new CoreLocalFileSystem();
    }

    public MockApplication getApplication() {
        return this.myApplication;
    }

    public Disposable getParentDisposable() {
        return this.myParentDisposable;
    }

    public void registerFileType(FileType fileType, String extension) {
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(ParserDefinition definition) {
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), definition);
    }

    public static <T> void registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    public <T> void addExplicitExtension(final LanguageExtension<T> instance, final Language language, final T object) {
        instance.addExplicitExtension(language, object);
        Disposer.register(this.myParentDisposable, new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(language, object);
            }
        });
    }

    public <T> void addExplicitExtension(final FileTypeExtension<T> instance, final FileType fileType, final T object) {
        instance.addExplicitExtension(fileType, object);
        Disposer.register(this.myParentDisposable, new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(fileType, object);
            }
        });
    }

    public <T> void addExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint<T> extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register(this.myParentDisposable, new Disposable(){

            @Override
            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    public static <T> void registerExtensionPoint(ExtensionsArea area, ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        CoreApplicationEnvironment.registerExtensionPoint(area, name, aClass);
    }

    public static <T> void registerExtensionPoint(ExtensionsArea area, String name, Class<? extends T> aClass) {
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    public static <T> void registerApplicationExtensionPoint(ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), name, aClass);
    }

    public CoreLocalFileSystem getLocalFileSystem() {
        return this.myLocalFileSystem;
    }

    public VirtualFileSystem getJarFileSystem() {
        return this.myJarFileSystem;
    }
}

