/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressIndicatorProvider {
    @Nullable
    public static ProgressIndicatorProvider ourInstance;
    public static volatile boolean ourNeedToCheckCancel;

    public abstract ProgressIndicator getProgressIndicator();

    protected abstract void doCheckCanceled() throws ProcessCanceledException;

    @Nullable
    public static ProgressIndicator getGlobalProgressIndicator() {
        return ourInstance != null ? ourInstance.getProgressIndicator() : null;
    }

    public abstract NonCancelableSection startNonCancelableSection();

    @NotNull
    public static NonCancelableSection startNonCancelableSectionIfSupported() {
        NonCancelableSection nonCancelableSection = ourInstance != null ? ourInstance.startNonCancelableSection() : NonCancelableSection.EMPTY;
        if (nonCancelableSection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/ProgressIndicatorProvider", "startNonCancelableSectionIfSupported"));
        }
        return nonCancelableSection;
    }

    public static void checkCanceled() throws ProcessCanceledException {
        if (ourNeedToCheckCancel && ourInstance != null) {
            ourInstance.doCheckCanceled();
            ourNeedToCheckCancel = false;
        }
    }

    static {
        ourNeedToCheckCancel = false;
    }
}

