/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class InputOutputConstraintFormula
implements ConstraintFormula {
    protected abstract PsiExpression getExpression();

    protected abstract PsiType getT();

    protected abstract InputOutputConstraintFormula createSelfConstraint(PsiType var1, PsiExpression var2);

    protected abstract void collectReturnTypeVariables(InferenceSession var1, PsiExpression var2, PsiMethod var3, Set<InferenceVariable> var4);

    public Set<InferenceVariable> getInputVariables(InferenceSession session) {
        PsiExpression psiExpression = this.getExpression();
        if (PsiPolyExpressionUtil.isPolyExpression(psiExpression)) {
            PsiType type = this.getT();
            if (psiExpression instanceof PsiLambdaExpression || psiExpression instanceof PsiMethodReferenceExpression) {
                PsiType functionType;
                PsiClassType.ClassResolveResult resolveResult;
                PsiMethod interfaceMethod;
                PsiType functionalInterfaceType;
                InferenceVariable inferenceVariable = session.getInferenceVariable(type);
                if (inferenceVariable != null) {
                    return Collections.singleton(inferenceVariable);
                }
                PsiType psiType = functionalInterfaceType = psiExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)psiExpression).getFunctionalInterfaceType() : ((PsiMethodReferenceExpression)psiExpression).getFunctionalInterfaceType();
                if (functionalInterfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionType = psiExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getFunctionalType(functionalInterfaceType, (PsiLambdaExpression)psiExpression) : functionalInterfaceType))) != null) {
                    HashSet<InferenceVariable> result = new HashSet<InferenceVariable>();
                    PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                    for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                        session.collectDependencies(substitutor.substitute(parameter.getType()), result, true);
                    }
                    this.collectReturnTypeVariables(session, psiExpression, interfaceMethod, result);
                    return result;
                }
            }
            if (psiExpression instanceof PsiParenthesizedExpression) {
                PsiExpression expression = ((PsiParenthesizedExpression)psiExpression).getExpression();
                return expression != null ? this.createSelfConstraint(type, expression).getInputVariables(session) : null;
            }
            if (psiExpression instanceof PsiConditionalExpression) {
                Set<InferenceVariable> elseResult;
                PsiExpression thenExpression = ((PsiConditionalExpression)psiExpression).getThenExpression();
                PsiExpression elseExpression = ((PsiConditionalExpression)psiExpression).getElseExpression();
                Set<InferenceVariable> thenResult = thenExpression != null ? this.createSelfConstraint(type, thenExpression).getInputVariables(session) : null;
                Set<InferenceVariable> set = elseResult = elseExpression != null ? this.createSelfConstraint(type, elseExpression).getInputVariables(session) : null;
                if (thenResult == null) {
                    return elseResult;
                }
                if (elseResult == null) {
                    return thenResult;
                }
                thenResult.addAll(elseResult);
                return thenResult;
            }
        }
        return null;
    }

    @Nullable
    public Set<InferenceVariable> getOutputVariables(Set<InferenceVariable> inputVariables, InferenceSession session) {
        if (!PsiPolyExpressionUtil.isPolyExpression(this.getExpression())) {
            HashSet<InferenceVariable> mentionedVariables = new HashSet<InferenceVariable>();
            session.collectDependencies(this.getT(), mentionedVariables, true);
            mentionedVariables.removeAll(inputVariables);
            return mentionedVariables;
        }
        return null;
    }
}

