/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance("#" + PsiMethodReferenceCompatibilityConstraint.class.getName());
    private final PsiMethodReferenceExpression myExpression;
    private final PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiParameter[] parameters;
        if (LambdaHighlightingUtil.checkInterfaceFunctional(this.myT) != null) {
            return false;
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(this.myT);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, PsiUtil.resolveGenericsClassInType(this.myT));
        for (PsiParameter parameter : parameters = interfaceMethod.getParameterList().getParameters()) {
            if (session.isProperType(substitutor.substitute(parameter.getType()))) continue;
            return false;
        }
        PsiElement resolve = this.myExpression.resolve();
        if (resolve == null) {
            return false;
        }
        PsiType returnType = interfaceMethod.getReturnType();
        LOG.assertTrue(returnType != null, interfaceMethod);
        if (PsiType.VOID.equals(returnType)) {
            return true;
        }
        if (resolve instanceof PsiMethod) {
            PsiType referencedMethodReturnType;
            PsiMethod method = (PsiMethod)resolve;
            if (method.isConstructor()) {
                PsiClass containingClass = method.getContainingClass();
                LOG.assertTrue(containingClass != null, method);
                referencedMethodReturnType = JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass);
            } else {
                referencedMethodReturnType = method.getReturnType();
            }
            LOG.assertTrue(referencedMethodReturnType != null, method);
            if (this.myExpression.getTypeParameters().length == 0 && ((PsiMethod)resolve).getTypeParameters().length > 0 && PsiPolyExpressionUtil.mentionsTypeParameters(returnType, new HashSet<PsiTypeParameter>(Arrays.asList(interfaceMethod.getTypeParameters()))).booleanValue()) {
                return true;
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                return false;
            }
            constraints.add(new TypeCompatibilityConstraint(substitutor.substitute(returnType), referencedMethodReturnType));
        }
        return true;
    }
}

