/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeEqualityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance("#" + TypeEqualityConstraint.class.getName());
    private PsiType myT;
    private PsiType myS;

    public TypeEqualityConstraint(@NotNull PsiType t, @NotNull PsiType s) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeEqualityConstraint", "<init>"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeEqualityConstraint", "<init>"));
        }
        this.myT = t;
        this.myS = s;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            return this.myT.equals(this.myS);
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myT, InferenceBound.EQ);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myT);
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myS, InferenceBound.EQ);
            return true;
        }
        if (this.myT instanceof PsiClassType && this.myS instanceof PsiClassType) {
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClassType.ClassResolveResult sResult = ((PsiClassType)this.myS).resolveGenerics();
            PsiClass C = tResult.getElement();
            if (C == sResult.getElement() && C != null) {
                PsiSubstitutor tSubstitutor = tResult.getSubstitutor();
                PsiSubstitutor sSubstitutor = sResult.getSubstitutor();
                for (PsiTypeParameter typeParameter : C.getTypeParameters()) {
                    PsiType tSubstituted = tSubstitutor.substitute(typeParameter);
                    PsiType sSubstituted = sSubstitutor.substitute(typeParameter);
                    if (tSubstituted == null || sSubstituted == null) continue;
                    constraints.add(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                }
                return true;
            }
        }
        if (this.myT instanceof PsiArrayType && this.myS instanceof PsiArrayType) {
            constraints.add(new TypeEqualityConstraint(((PsiArrayType)this.myT).getComponentType(), ((PsiArrayType)this.myS).getComponentType()));
            return true;
        }
        if (this.myT instanceof PsiIntersectionType && this.myS instanceof PsiIntersectionType) {
            PsiType[] tConjuncts = ((PsiIntersectionType)this.myT).getConjuncts();
            PsiType[] sConjuncts = ((PsiIntersectionType)this.myS).getConjuncts();
            if (sConjuncts.length == tConjuncts.length) {
                for (int i = 0; i < sConjuncts.length; ++i) {
                    constraints.add(new TypeEqualityConstraint(tConjuncts[i], sConjuncts[i]));
                }
                return true;
            }
        }
        if (this.myT instanceof PsiWildcardType && this.myS instanceof PsiWildcardType) {
            PsiType tBound = ((PsiWildcardType)this.myT).getBound();
            PsiType sBound = ((PsiWildcardType)this.myS).getBound();
            if (tBound == null && sBound == null) {
                return true;
            }
            if (((PsiWildcardType)this.myT).isExtends() && ((PsiWildcardType)this.myS).isExtends() || ((PsiWildcardType)this.myT).isSuper() && ((PsiWildcardType)this.myS).isSuper()) {
                LOG.assertTrue(tBound != null);
                LOG.assertTrue(sBound != null);
                constraints.add(new TypeEqualityConstraint(tBound, sBound));
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeEqualityConstraint that = (TypeEqualityConstraint)o;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result = this.myT.hashCode();
        result = 31 * result + this.myS.hashCode();
        return result;
    }
}

