/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiReturnStatementImpl
extends CompositePsiElement
implements PsiReturnStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiReturnStatementImpl");

    public PsiReturnStatementImpl() {
        super(RETURN_STATEMENT);
    }

    @Override
    public PsiExpression getReturnValue() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(66);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 65: {
                return this.findChildByType(RETURN_KEYWORD);
            }
            case 66: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == RETURN_KEYWORD) {
            return 65;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 66;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiReturnStatementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReturnStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiReturnStatement";
    }
}

