/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.WeakHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class WeakKeyWeakValueHashMap<K, V>
implements Map<K, V> {
    private final WeakHashMap<K, MyValueReference<K, V>> myWeakKeyMap = new WeakHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    private void processQueue() {
        MyValueReference ref;
        this.myWeakKeyMap.processQueue();
        while ((ref = (MyValueReference)this.myQueue.poll()) != null) {
            RefHashMap.Key weakKey = ref.key;
            this.myWeakKeyMap.removeKey(weakKey);
        }
    }

    @Override
    public V get(Object key) {
        MyValueReference ref = (MyValueReference)this.myWeakKeyMap.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        RefHashMap.Key<K> weakKey = this.myWeakKeyMap.createKey(key);
        MyValueReference reference = new MyValueReference(weakKey, value, this.myQueue);
        MyValueReference oldRef = this.myWeakKeyMap.putKey(weakKey, reference);
        return oldRef == null ? null : (V)oldRef.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyValueReference ref = (MyValueReference)this.myWeakKeyMap.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        this.myWeakKeyMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myWeakKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myWeakKeyMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.myWeakKeyMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakKeyWeakValueHashMap", "keySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myWeakKeyMap.values();
        for (MyValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakKeyWeakValueHashMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("method not implemented");
    }

    private static class MyValueReference<K, V>
    extends WeakReference<V> {
        private final RefHashMap.Key<K> key;

        private MyValueReference(RefHashMap.Key<K> key, V referent, ReferenceQueue<? super V> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

