/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.ClassReader;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.jet.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class StubClassBuilder
extends ClassBuilder {
    private static final InnerClassSourceStrategy<Object> EMPTY_STRATEGY = new InnerClassSourceStrategy<Object>(){

        @Override
        public Object findInnerClass(String s, Object o) {
            return null;
        }

        @Override
        public ClassReader readerForInnerClass(Object o) {
            throw new UnsupportedOperationException("Shall not be called!");
        }
    };
    private final StubElement parent;
    private StubBuildingVisitor v;
    private final Stack<StubElement> parentStack;
    private boolean isNamespace;

    public StubClassBuilder(@NotNull Stack<StubElement> parentStack) {
        if (parentStack == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/asJava/StubClassBuilder", "<init>"));
        }
        this.isNamespace = false;
        this.parentStack = parentStack;
        this.parent = parentStack.peek();
    }

    @Override
    @NotNull
    public ClassVisitor getVisitor() {
        assert (this.v != null) : "Called before class is defined";
        StubBuildingVisitor stubBuildingVisitor = this.v;
        if (stubBuildingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/StubClassBuilder", "getVisitor"));
        }
        return stubBuildingVisitor;
    }

    @Override
    public void defineClass(PsiElement origin, int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        FqName packageName;
        String packageClassName;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/asJava/StubClassBuilder", "defineClass"));
        }
        if (superName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/asJava/StubClassBuilder", "defineClass"));
        }
        if (interfaces == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/jet/asJava/StubClassBuilder", "defineClass"));
        }
        assert (this.v == null) : "defineClass() called twice?";
        this.v = new StubBuildingVisitor<Object>(null, EMPTY_STRATEGY, this.parent, access);
        super.defineClass(origin, version, access, name, signature, superName, interfaces);
        if (origin instanceof JetFile && (name.equals(packageClassName = PackageClassUtils.getPackageClassName(packageName = JetPsiUtil.getFQName((JetFile)origin))) || name.endsWith("/" + packageClassName))) {
            this.isNamespace = true;
        }
        if (!this.isNamespace) {
            this.parentStack.push(this.v.getResult());
        }
        ((StubBase)((Object)this.v.getResult())).putUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT, origin);
    }

    @Override
    public MethodVisitor newMethod(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/asJava/StubClassBuilder", "newMethod"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/asJava/StubClassBuilder", "newMethod"));
        }
        MethodVisitor internalVisitor = super.newMethod(origin, access, name, desc, signature, exceptions);
        if (internalVisitor != null) {
            this.markLastChild(origin);
        }
        return internalVisitor;
    }

    @Override
    public FieldVisitor newField(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/asJava/StubClassBuilder", "newField"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/asJava/StubClassBuilder", "newField"));
        }
        FieldVisitor internalVisitor = super.newField(origin, access, name, desc, signature, value);
        if (internalVisitor != null) {
            this.markLastChild(origin);
        }
        return internalVisitor;
    }

    private void markLastChild(@Nullable PsiElement origin) {
        List<StubElement> children = this.v.getResult().getChildrenStubs();
        StubBase last = (StubBase)children.get(children.size() - 1);
        PsiElement oldOrigin = last.getUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT);
        if (oldOrigin != null) {
            throw new IllegalStateException("Rewriting origin element: " + oldOrigin.getText() + " for stub " + last.toString());
        }
        last.putUserData(ClsWrapperStubPsiFactory.ORIGIN_ELEMENT, origin);
    }

    @Override
    public void done() {
        if (!this.isNamespace) {
            StubElement pop = this.parentStack.pop();
            assert (pop == this.v.getResult());
        }
        super.done();
    }
}

