/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;

public class MessageSeverityCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Set<CompilerMessageSeverity> reportedSeverities;

    public MessageSeverityCollector(@NotNull MessageCollector delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/MessageSeverityCollector", "<init>"));
        }
        this.reportedSeverities = Sets.newHashSet();
        this.delegate = delegate;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/MessageSeverityCollector", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/common/messages/MessageSeverityCollector", "report"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/cli/common/messages/MessageSeverityCollector", "report"));
        }
        this.delegate.report(severity, message, location);
        this.reportedSeverities.add(severity);
    }

    public boolean anyReported(CompilerMessageSeverity ... severities) {
        if (severities == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/common/messages/MessageSeverityCollector", "anyReported"));
        }
        return this.reportedSeverities.containsAll(Arrays.asList(severities));
    }
}

