/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.jvm.compiler.ClassPath;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileKotlinClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassFileHeader;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class CliVirtualFileFinder
implements VirtualFileFinder {
    @NotNull
    private final ClassPath classPath;

    public CliVirtualFileFinder(@NotNull ClassPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "<init>"));
        }
        this.classPath = path;
    }

    @Override
    @Nullable
    public VirtualFile find(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "find"));
        }
        for (VirtualFile root : this.classPath) {
            VirtualFile fileInRoot = CliVirtualFileFinder.findFileInRoot(className.asString(), root);
            if (fileInRoot == null) continue;
            return fileInRoot;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFileInRoot(@NotNull String qName, @NotNull VirtualFile root) {
        String pathComponent;
        VirtualFile child;
        int dot;
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "findFileInRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/cli/jvm/compiler/CliVirtualFileFinder", "findFileInRoot"));
        }
        String pathRest = qName;
        VirtualFile cur = root;
        while ((dot = pathRest.indexOf(46)) >= 0 && (child = cur.findChild(pathComponent = pathRest.substring(0, dot))) != null) {
            pathRest = pathRest.substring(dot + 1);
            cur = child;
        }
        String className = pathRest.replace('.', '$');
        VirtualFile vFile = cur.findChild(className + ".class");
        if (vFile != null) {
            if (!vFile.isValid()) {
                return null;
            }
            if (KotlinClassFileHeader.readKotlinHeaderFromClassFile(new VirtualFileKotlinClass(vFile)) != null) {
                return vFile;
            }
        }
        return null;
    }
}

