/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;

public class FieldInfo {
    private final Type fieldType;
    private final Type ownerType;
    private final String fieldName;
    private final boolean isStatic;

    @NotNull
    public static FieldInfo createForSingleton(@NotNull ClassDescriptor fieldClassDescriptor, @NotNull JetTypeMapper typeMapper) {
        ClassDescriptor ownerDescriptor;
        if (fieldClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/FieldInfo", "createForSingleton"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/FieldInfo", "createForSingleton"));
        }
        ClassKind kind = fieldClassDescriptor.getKind();
        if (kind != ClassKind.OBJECT && kind != ClassKind.CLASS_OBJECT && kind != ClassKind.ENUM_ENTRY) {
            throw new UnsupportedOperationException();
        }
        Type fieldType = typeMapper.mapType(fieldClassDescriptor.getDefaultType());
        ClassDescriptor classDescriptor = ownerDescriptor = kind == ClassKind.OBJECT ? fieldClassDescriptor : DescriptorUtils.getParentOfType(fieldClassDescriptor, ClassDescriptor.class);
        assert (ownerDescriptor != null);
        Type ownerType = typeMapper.mapType(ownerDescriptor.getDefaultType());
        String fieldName = kind == ClassKind.ENUM_ENTRY ? fieldClassDescriptor.getName().asString() : (fieldClassDescriptor.getKind() == ClassKind.CLASS_OBJECT ? "object$" : "instance$");
        FieldInfo fieldInfo = new FieldInfo(ownerType, fieldType, fieldName, true);
        if (fieldInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FieldInfo", "createForSingleton"));
        }
        return fieldInfo;
    }

    public static FieldInfo createForHiddenField(@NotNull Type owner, Type fieldType, String fieldName) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/FieldInfo", "createForHiddenField"));
        }
        return new FieldInfo(owner, fieldType, fieldName, false);
    }

    private FieldInfo(@NotNull Type ownerType, @NotNull Type fieldType, @NotNull String fieldName, @NotNull boolean isStatic) {
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/FieldInfo", "<init>"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/FieldInfo", "<init>"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/FieldInfo", "<init>"));
        }
        this.ownerType = ownerType;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    @NotNull
    public Type getFieldType() {
        Type type = this.fieldType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FieldInfo", "getFieldType"));
        }
        return type;
    }

    @NotNull
    public Type getOwnerType() {
        Type type = this.ownerType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FieldInfo", "getOwnerType"));
        }
        return type;
    }

    @NotNull
    public String getOwnerInternalName() {
        String string = this.ownerType.getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FieldInfo", "getOwnerInternalName"));
        }
        return string;
    }

    @NotNull
    public String getFieldName() {
        String string = this.fieldName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FieldInfo", "getFieldName"));
        }
        return string;
    }

    @NotNull
    public boolean isStatic() {
        return this.isStatic;
    }
}

