/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.TraitImplBodyCodegen;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.types.ErrorUtils;

public class MemberCodegen
extends GenerationStateAware {
    @Nullable
    private MemberCodegen parentCodegen;

    public MemberCodegen(@NotNull GenerationState state, @Nullable MemberCodegen parentCodegen) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberCodegen", "<init>"));
        }
        super(state);
        this.parentCodegen = parentCodegen;
    }

    @Nullable
    public MemberCodegen getParentCodegen() {
        return this.parentCodegen;
    }

    public void genFunctionOrProperty(@NotNull FieldOwnerContext context, @NotNull JetTypeParameterListOwner functionOrProperty, @NotNull ClassBuilder classBuilder) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        if (functionOrProperty == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/MemberCodegen", "genFunctionOrProperty"));
        }
        FunctionCodegen functionCodegen = new FunctionCodegen(context, classBuilder, this.state);
        if (functionOrProperty instanceof JetNamedFunction) {
            try {
                functionCodegen.gen((JetNamedFunction)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else if (functionOrProperty instanceof JetProperty) {
            try {
                new PropertyCodegen(context, classBuilder, functionCodegen, this).gen((JetProperty)functionOrProperty);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + functionOrProperty.getName(), e, functionOrProperty);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + functionOrProperty);
        }
    }

    public void genClassOrObject(CodegenContext parentContext, JetClassOrObject aClass) {
        ClassDescriptor descriptor = this.state.getBindingContext().get(BindingContext.CLASS, aClass);
        if (descriptor == null || ErrorUtils.isError(descriptor) || descriptor.getName().equals(JetPsiUtil.NO_NAME_PROVIDED)) {
            if (this.state.getClassBuilderMode() != ClassBuilderMode.SIGNATURES) {
                throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + (Object)((Object)this.state.getClassBuilderMode()) + ": " + descriptor);
            }
            return;
        }
        ClassBuilder classBuilder = this.state.getFactory().forClassImplementation(descriptor, aClass.getContainingFile());
        ClassContext classContext = parentContext.intoClass(descriptor, OwnerKind.IMPLEMENTATION, this.state);
        new ImplementationBodyCodegen(aClass, classContext, classBuilder, this.state, this).generate();
        classBuilder.done();
        if (aClass instanceof JetClass && ((JetClass)aClass).isTrait()) {
            ClassBuilder traitBuilder = this.state.getFactory().forTraitImplementation(descriptor, this.state, aClass.getContainingFile());
            new TraitImplBodyCodegen(aClass, parentContext.intoClass(descriptor, OwnerKind.TRAIT_IMPL, this.state), traitBuilder, this.state).generate();
            traitBuilder.done();
        }
    }
}

