/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.KotlinCodegenFacade;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.ScriptContext;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;

public class ScriptCodegen
extends MemberCodegen {
    @NotNull
    private ClassFileFactory classFileFactory;
    private List<ScriptDescriptor> earlierScripts;
    private Method scriptConstructorMethod;

    public ScriptCodegen(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "<init>"));
        }
        super(state, null);
    }

    public void setClassFileFactory(@NotNull ClassFileFactory classFileFactory) {
        if (classFileFactory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "setClassFileFactory"));
        }
        this.classFileFactory = classFileFactory;
    }

    public void generate(JetScript scriptDeclaration) {
        ScriptDescriptor scriptDescriptor = this.state.getBindingContext().get(BindingContext.SCRIPT, scriptDeclaration);
        assert (scriptDescriptor != null);
        ClassDescriptor classDescriptorForScript = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, scriptDescriptor);
        assert (classDescriptorForScript != null);
        ScriptContext context = (ScriptContext)CodegenContext.STATIC.intoScript(scriptDescriptor, classDescriptorForScript);
        JvmClassName className = this.bindingContext.get(CodegenBinding.FQN, classDescriptorForScript);
        assert (className != null);
        ClassBuilder classBuilder = this.classFileFactory.newVisitor(className, scriptDeclaration.getContainingFile());
        classBuilder.defineClass(scriptDeclaration, 50, 1, className.getInternalName(), null, "java/lang/Object", new String[0]);
        this.genMembers(scriptDeclaration, context, classBuilder);
        this.genFieldsForParameters(scriptDescriptor, classBuilder);
        this.genConstructor(scriptDeclaration, scriptDescriptor, classDescriptorForScript, classBuilder, context.intoFunction(scriptDescriptor.getScriptCodeDescriptor()), this.earlierScripts);
        classBuilder.done();
    }

    private void genConstructor(@NotNull JetScript scriptDeclaration, @NotNull ScriptDescriptor scriptDescriptor, @NotNull ClassDescriptor classDescriptorForScript, @NotNull ClassBuilder classBuilder, @NotNull MethodContext context, @NotNull List<ScriptDescriptor> importedScripts) {
        if (scriptDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (classDescriptorForScript == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        if (importedScripts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/codegen/ScriptCodegen", "genConstructor"));
        }
        Type blockType = this.typeMapper.mapType(scriptDescriptor.getReturnType());
        classBuilder.newField(null, 17, "rv", blockType.getDescriptor(), null, null);
        JvmMethodSignature jvmSignature = this.typeMapper.mapScriptSignature(scriptDescriptor, importedScripts);
        this.state.getScriptCodegen().setScriptConstructorMethod(jvmSignature.getAsmMethod());
        MethodVisitor mv = classBuilder.newMethod(scriptDeclaration, 1, jvmSignature.getAsmMethod().getName(), jvmSignature.getAsmMethod().getDescriptor(), null, null);
        mv.visitCode();
        InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
        JvmClassName className = this.bindingContext.get(CodegenBinding.FQN, classDescriptorForScript);
        assert (className != null);
        instructionAdapter.load(0, className.getAsmType());
        instructionAdapter.invokespecial("java/lang/Object", "<init>", "()V");
        instructionAdapter.load(0, className.getAsmType());
        FrameMap frameMap = context.prepareFrame(this.typeMapper);
        for (ScriptDescriptor importedScript : importedScripts) {
            frameMap.enter(importedScript, AsmTypeConstants.OBJECT_TYPE);
        }
        Type[] argTypes = jvmSignature.getAsmMethod().getArgumentTypes();
        int add = 0;
        for (int i = 0; i < scriptDescriptor.getValueParameters().size(); ++i) {
            ValueParameterDescriptor parameter = scriptDescriptor.getValueParameters().get(i);
            frameMap.enter(parameter, argTypes[i + add]);
        }
        ImplementationBodyCodegen.generateInitializers(new ExpressionCodegen(instructionAdapter, frameMap, Type.VOID_TYPE, context, this.state), scriptDeclaration.getDeclarations(), this.bindingContext, this.state);
        int offset = 1;
        for (ScriptDescriptor earlierScript : importedScripts) {
            JvmClassName earlierClassName = CodegenBinding.classNameForScriptDescriptor(this.bindingContext, earlierScript);
            instructionAdapter.load(0, className.getAsmType());
            instructionAdapter.load(offset, earlierClassName.getAsmType());
            offset += earlierClassName.getAsmType().getSize();
            instructionAdapter.putfield(className.getInternalName(), this.getScriptFieldName(earlierScript), earlierClassName.getAsmType().getDescriptor());
        }
        for (ValueParameterDescriptor parameter : scriptDescriptor.getValueParameters()) {
            Type parameterType = this.typeMapper.mapType(parameter.getType());
            instructionAdapter.load(0, className.getAsmType());
            instructionAdapter.load(offset, parameterType);
            offset += parameterType.getSize();
            instructionAdapter.putfield(className.getInternalName(), parameter.getName().getIdentifier(), parameterType.getDescriptor());
        }
        StackValue stackValue = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, context, this.state).gen(scriptDeclaration.getBlockExpression());
        if (stackValue.type != Type.VOID_TYPE) {
            stackValue.put(stackValue.type, instructionAdapter);
            instructionAdapter.putfield(className.getInternalName(), "rv", blockType.getDescriptor());
        }
        instructionAdapter.areturn(Type.VOID_TYPE);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void genFieldsForParameters(@NotNull ScriptDescriptor script, @NotNull ClassBuilder classBuilder) {
        int access;
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "genFieldsForParameters"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "genFieldsForParameters"));
        }
        for (ScriptDescriptor earlierScript : this.earlierScripts) {
            JvmClassName earlierClassName = CodegenBinding.classNameForScriptDescriptor(this.bindingContext, earlierScript);
            access = 18;
            classBuilder.newField(null, access, this.getScriptFieldName(earlierScript), earlierClassName.getDescriptor(), null, null);
        }
        for (ValueParameterDescriptor parameter : script.getValueParameters()) {
            Type parameterType = this.typeMapper.mapType(parameter);
            access = 17;
            classBuilder.newField(null, access, parameter.getName().getIdentifier(), parameterType.getDescriptor(), null, null);
        }
    }

    private void genMembers(@NotNull JetScript scriptDeclaration, @NotNull FieldOwnerContext context, @NotNull ClassBuilder classBuilder) {
        if (scriptDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "genMembers"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "genMembers"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/ScriptCodegen", "genMembers"));
        }
        for (JetDeclaration decl : scriptDeclaration.getDeclarations()) {
            this.genFunctionOrProperty(context, (JetTypeParameterListOwner)decl, classBuilder);
        }
    }

    public void registerEarlierScripts(List<Pair<ScriptDescriptor, JvmClassName>> earlierScripts) {
        for (Pair<ScriptDescriptor, JvmClassName> t : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)t.first;
            JvmClassName earlierClassName = (JvmClassName)t.second;
            CodegenBinding.registerClassNameForScript(this.state.getBindingTrace(), earlierDescriptor, earlierClassName);
        }
        ArrayList<ScriptDescriptor> earlierScriptDescriptors = Lists.newArrayList();
        for (Pair<ScriptDescriptor, JvmClassName> t : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)t.first;
            earlierScriptDescriptors.add(earlierDescriptor);
        }
        this.earlierScripts = earlierScriptDescriptors;
    }

    protected int getScriptIndex(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "getScriptIndex"));
        }
        int index = this.earlierScripts.indexOf(scriptDescriptor);
        if (index < 0) {
            throw new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        return index + 1;
    }

    public String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "getScriptFieldName"));
        }
        return "script$" + this.getScriptIndex(scriptDescriptor);
    }

    public void setScriptConstructorMethod(Method scriptConstructorMethod) {
        this.scriptConstructorMethod = scriptConstructorMethod;
    }

    public Method getScriptConstructorMethod() {
        return this.scriptConstructorMethod;
    }

    public void compileScript(@NotNull JetScript script, @NotNull JvmClassName className, @NotNull List<Pair<ScriptDescriptor, JvmClassName>> earlierScripts, @NotNull CompilationErrorHandler errorHandler) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ScriptCodegen", "compileScript"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/ScriptCodegen", "compileScript"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/ScriptCodegen", "compileScript"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/codegen/ScriptCodegen", "compileScript"));
        }
        this.registerEarlierScripts(earlierScripts);
        CodegenBinding.registerClassNameForScript(this.state.getBindingTrace(), script, className);
        this.state.beforeCompile();
        KotlinCodegenFacade.generateNamespace(this.state, JetPsiUtil.getFQName((JetFile)script.getContainingFile()), Collections.singleton((JetFile)script.getContainingFile()), errorHandler);
    }
}

