/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class StackValue {
    @NotNull
    public final Type type;

    protected StackValue(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/StackValue", "<init>"));
        }
        this.type = type;
    }

    public abstract void put(Type var1, InstructionAdapter var2);

    protected void moveToTopOfStack(Type type, InstructionAdapter v, int depth) {
        this.put(type, v);
    }

    public void store(Type topOfStackType, InstructionAdapter v) {
        throw new UnsupportedOperationException("cannot store to value " + this);
    }

    public void dupReceiver(InstructionAdapter v) {
    }

    public int receiverSize() {
        return 0;
    }

    public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
        this.put(this.type, v);
        this.coerceTo(Type.BOOLEAN_TYPE, v);
        if (jumpIfFalse) {
            v.ifeq(label);
        } else {
            v.ifne(label);
        }
    }

    public static Local local(int index, Type type) {
        return new Local(index, type);
    }

    public static StackValue shared(int index, Type type) {
        return new Shared(index, type);
    }

    public static StackValue onStack(Type type) {
        return type == Type.VOID_TYPE ? StackValue.none() : new OnStack(type);
    }

    public static StackValue constant(@Nullable Object value, Type type) {
        return new Constant(value, type);
    }

    public static StackValue cmp(IElementType opToken, Type type) {
        return type.getSort() == 10 ? new ObjectCompare(opToken, type) : new NumberCompare(opToken, type);
    }

    public static StackValue not(StackValue stackValue) {
        return new Invert(stackValue);
    }

    @NotNull
    public static StackValue arrayElement(Type type, boolean unbox) {
        ArrayElement arrayElement = new ArrayElement(type, unbox);
        if (arrayElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "arrayElement"));
        }
        return arrayElement;
    }

    @NotNull
    public static StackValue collectionElement(Type type, ResolvedCall<FunctionDescriptor> getter, ResolvedCall<FunctionDescriptor> setter, ExpressionCodegen codegen, GenerationState state) {
        CollectionElement collectionElement = new CollectionElement(type, getter, setter, codegen, state);
        if (collectionElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "collectionElement"));
        }
        return collectionElement;
    }

    @NotNull
    public static Field field(@NotNull Type type, @NotNull JvmClassName owner, @NotNull String name, boolean isStatic) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        Field field = new Field(type, owner, name, isStatic);
        if (field == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "field"));
        }
        return field;
    }

    @NotNull
    public static Property property(@NotNull PropertyDescriptor descriptor, @NotNull JvmClassName methodOwner, @NotNull Type type, boolean isStatic, @NotNull String name, @Nullable CallableMethod getter, @Nullable CallableMethod setter, GenerationState state) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        if (methodOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        Property property = new Property(descriptor, methodOwner, getter, setter, isStatic, name, type, state);
        if (property == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "property"));
        }
        return property;
    }

    @NotNull
    public static StackValue expression(Type type, JetExpression expression, ExpressionCodegen generator) {
        Expression expression2 = new Expression(type, expression, generator);
        if (expression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/StackValue", "expression"));
        }
        return expression2;
    }

    private static void box(Type type, Type toType, InstructionAdapter v) {
        if (type == Type.INT_TYPE || AsmUtil.isIntPrimitive(type) && toType.getInternalName().equals("java/lang/Integer")) {
            v.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (type == Type.BOOLEAN_TYPE) {
            v.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (type == Type.CHAR_TYPE) {
            v.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (type == Type.SHORT_TYPE) {
            v.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (type == Type.LONG_TYPE) {
            v.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (type == Type.BYTE_TYPE) {
            v.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (type == Type.FLOAT_TYPE) {
            v.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (type == Type.DOUBLE_TYPE) {
            v.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        }
    }

    private static void unbox(Type type, InstructionAdapter v) {
        if (type == Type.INT_TYPE) {
            v.invokevirtual("java/lang/Number", "intValue", "()I");
        } else if (type == Type.BOOLEAN_TYPE) {
            v.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
        } else if (type == Type.CHAR_TYPE) {
            v.invokevirtual("java/lang/Character", "charValue", "()C");
        } else if (type == Type.SHORT_TYPE) {
            v.invokevirtual("java/lang/Number", "shortValue", "()S");
        } else if (type == Type.LONG_TYPE) {
            v.invokevirtual("java/lang/Number", "longValue", "()J");
        } else if (type == Type.BYTE_TYPE) {
            v.invokevirtual("java/lang/Number", "byteValue", "()B");
        } else if (type == Type.FLOAT_TYPE) {
            v.invokevirtual("java/lang/Number", "floatValue", "()F");
        } else if (type == Type.DOUBLE_TYPE) {
            v.invokevirtual("java/lang/Number", "doubleValue", "()D");
        }
    }

    protected void coerceTo(Type toType, InstructionAdapter v) {
        StackValue.coerce(this.type, toType, v);
    }

    protected void coerceFrom(Type topOfStackType, InstructionAdapter v) {
        StackValue.coerce(topOfStackType, this.type, v);
    }

    public static void coerce(Type fromType, Type toType, InstructionAdapter v) {
        if (toType.equals(fromType)) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypeConstants.JET_UNIT_TYPE) || toType.equals(AsmTypeConstants.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else if (toType.getSort() == 10 || toType.getSort() == 9) {
                v.aconst(null);
            } else {
                AsmUtil.pushDefaultPrimitiveValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypeConstants.JET_UNIT_TYPE)) {
            AsmUtil.pop(v, fromType);
            StackValue.putUnitInstance(v);
        } else if (toType.getSort() == 9) {
            v.checkcast(toType);
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypeConstants.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10) {
            if (toType.getSort() == 1) {
                StackValue.coerce(fromType, JvmPrimitiveType.BOOLEAN.getWrapper().getAsmType(), v);
            } else if (toType.getSort() == 2) {
                StackValue.coerce(fromType, JvmPrimitiveType.CHAR.getWrapper().getAsmType(), v);
            } else {
                StackValue.coerce(fromType, AsmTypeConstants.getType(Number.class), v);
            }
            StackValue.unbox(toType, v);
        } else {
            v.cast(fromType, toType);
        }
    }

    public static void putUnitInstance(InstructionAdapter v) {
        v.visitFieldInsn(178, AsmTypeConstants.JET_UNIT_TYPE.getInternalName(), "VALUE", AsmTypeConstants.JET_UNIT_TYPE.getDescriptor());
    }

    protected void putAsBoolean(InstructionAdapter v) {
        Label ifTrue = new Label();
        Label end = new Label();
        this.condJump(ifTrue, false, v);
        v.iconst(0);
        v.goTo(end);
        v.mark(ifTrue);
        v.iconst(1);
        v.mark(end);
    }

    public static StackValue none() {
        return None.INSTANCE;
    }

    public static StackValue fieldForSharedVar(Type type, JvmClassName name, String fieldName) {
        return new FieldForSharedVar(type, name, fieldName);
    }

    public static StackValue composed(StackValue prefix, StackValue suffix) {
        return new Composed(prefix, suffix);
    }

    public static StackValue thisOrOuter(ExpressionCodegen codegen, ClassDescriptor descriptor, boolean isSuper) {
        boolean coerceType = descriptor.getKind() == ClassKind.TRAIT;
        return new ThisOuter(codegen, descriptor, isSuper, coerceType);
    }

    public static StackValue postIncrement(int index, int increment) {
        return new PostIncrement(index, increment);
    }

    public static StackValue preIncrement(int index, int increment) {
        return new PreIncrement(index, increment);
    }

    public static StackValue receiver(ResolvedCall<? extends CallableDescriptor> resolvedCall, StackValue receiver, ExpressionCodegen codegen, @Nullable CallableMethod callableMethod) {
        if (resolvedCall.getThisObject().exists() || resolvedCall.getReceiverArgument().exists()) {
            return new CallReceiver(resolvedCall, receiver, codegen, callableMethod, true);
        }
        return receiver;
    }

    public static StackValue receiverWithoutReceiverArgument(StackValue receiverWithParameter) {
        if (receiverWithParameter instanceof CallReceiver) {
            CallReceiver callReceiver = (CallReceiver)receiverWithParameter;
            return new CallReceiver(callReceiver.resolvedCall, callReceiver.receiver, callReceiver.codegen, callReceiver.callableMethod, false);
        }
        return receiverWithParameter;
    }

    public static Field singleton(ClassDescriptor classDescriptor, JetTypeMapper typeMapper) {
        FieldInfo info = FieldInfo.createForSingleton(classDescriptor, typeMapper);
        return StackValue.field(info.getFieldType(), JvmClassName.byInternalName(info.getOwnerInternalName()), info.getFieldName(), true);
    }

    public static Type sharedTypeForType(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return AsmTypeConstants.JET_SHARED_VAR_TYPE;
            }
            case 3: {
                return AsmTypeConstants.JET_SHARED_BYTE_TYPE;
            }
            case 4: {
                return AsmTypeConstants.JET_SHARED_SHORT_TYPE;
            }
            case 2: {
                return AsmTypeConstants.JET_SHARED_CHAR_TYPE;
            }
            case 5: {
                return AsmTypeConstants.JET_SHARED_INT_TYPE;
            }
            case 7: {
                return AsmTypeConstants.JET_SHARED_LONG_TYPE;
            }
            case 1: {
                return AsmTypeConstants.JET_SHARED_BOOLEAN_TYPE;
            }
            case 6: {
                return AsmTypeConstants.JET_SHARED_FLOAT_TYPE;
            }
            case 8: {
                return AsmTypeConstants.JET_SHARED_DOUBLE_TYPE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Type refType(Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return AsmTypeConstants.OBJECT_TYPE;
        }
        return type;
    }

    public static abstract class StackValueWithSimpleReceiver
    extends StackValue {
        protected final boolean isStatic;

        public StackValueWithSimpleReceiver(@NotNull Type type, boolean isStatic) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/StackValue$StackValueWithSimpleReceiver", "<init>"));
            }
            super(type);
            this.isStatic = isStatic;
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            if (!this.isStatic) {
                v.dup();
            }
        }

        @Override
        public int receiverSize() {
            return this.isStatic ? 0 : 1;
        }
    }

    public static class CallReceiver
    extends StackValue {
        private final ResolvedCall<? extends CallableDescriptor> resolvedCall;
        final StackValue receiver;
        private final ExpressionCodegen codegen;
        private final CallableMethod callableMethod;
        private final boolean putReceiverArgumentOnStack;

        public CallReceiver(ResolvedCall<? extends CallableDescriptor> resolvedCall, StackValue receiver, ExpressionCodegen codegen, CallableMethod callableMethod, boolean putReceiverArgumentOnStack) {
            super(CallReceiver.calcType(resolvedCall, codegen, callableMethod));
            this.resolvedCall = resolvedCall;
            this.receiver = receiver;
            this.codegen = codegen;
            this.callableMethod = callableMethod;
            this.putReceiverArgumentOnStack = putReceiverArgumentOnStack;
        }

        private static Type calcType(ResolvedCall<? extends CallableDescriptor> resolvedCall, ExpressionCodegen codegen, CallableMethod callableMethod) {
            ReceiverValue thisObject = resolvedCall.getThisObject();
            ReceiverValue receiverArgument = resolvedCall.getReceiverArgument();
            CallableDescriptor descriptor = resolvedCall.getResultingDescriptor();
            if (thisObject.exists()) {
                if (callableMethod != null) {
                    if (receiverArgument.exists()) {
                        return callableMethod.getReceiverClass();
                    }
                    return callableMethod.getThisType().getAsmType();
                }
                if (receiverArgument.exists()) {
                    return codegen.typeMapper.mapType(descriptor.getReceiverParameter().getType());
                }
                return codegen.typeMapper.mapType(descriptor.getExpectedThisObject().getType());
            }
            if (receiverArgument.exists()) {
                if (callableMethod != null) {
                    return callableMethod.getReceiverClass();
                }
                return codegen.typeMapper.mapType(descriptor.getReceiverParameter().getType());
            }
            return Type.VOID_TYPE;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            CallableDescriptor descriptor = this.resolvedCall.getResultingDescriptor();
            ReceiverValue thisObject = this.resolvedCall.getThisObject();
            ReceiverValue receiverArgument = this.resolvedCall.getReceiverArgument();
            if (thisObject.exists()) {
                if (receiverArgument.exists()) {
                    if (this.callableMethod != null) {
                        this.codegen.generateFromResolvedCall(thisObject, this.callableMethod.getOwner().getAsmType());
                    } else {
                        this.codegen.generateFromResolvedCall(thisObject, this.codegen.typeMapper.mapType(descriptor.getExpectedThisObject().getType()));
                    }
                    if (this.putReceiverArgumentOnStack) {
                        this.genReceiver(v, receiverArgument, type, descriptor.getReceiverParameter(), 1);
                    }
                } else {
                    this.genReceiver(v, thisObject, type, null, 0);
                }
            } else if (this.putReceiverArgumentOnStack && receiverArgument.exists()) {
                this.genReceiver(v, receiverArgument, type, descriptor.getReceiverParameter(), 0);
            }
        }

        private void genReceiver(InstructionAdapter v, ReceiverValue receiverArgument, Type type, @Nullable ReceiverParameterDescriptor receiverParameter, int depth) {
            if (this.receiver == StackValue.none()) {
                if (receiverParameter != null) {
                    Type receiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                    this.codegen.generateFromResolvedCall(receiverArgument, receiverType);
                    StackValue.onStack(receiverType).put(type, v);
                } else {
                    this.codegen.generateFromResolvedCall(receiverArgument, type);
                }
            } else {
                this.receiver.moveToTopOfStack(type, v, depth);
            }
        }
    }

    private static class PreIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PreIncrement(int index, int increment) {
            super(Type.INT_TYPE);
            this.index = index;
            this.increment = increment;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.iinc(this.index, this.increment);
            if (!type.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type, v);
            }
        }
    }

    private static class PostIncrement
    extends StackValue {
        private final int index;
        private final int increment;

        public PostIncrement(int index, int increment) {
            super(Type.INT_TYPE);
            this.index = index;
            this.increment = increment;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (!type.equals(Type.VOID_TYPE)) {
                v.load(this.index, Type.INT_TYPE);
                this.coerceTo(type, v);
            }
            v.iinc(this.index, this.increment);
        }
    }

    private static class ThisOuter
    extends StackValue {
        private final ExpressionCodegen codegen;
        private final ClassDescriptor descriptor;
        private final boolean isSuper;
        private final boolean coerceType;

        public ThisOuter(ExpressionCodegen codegen, ClassDescriptor descriptor, boolean isSuper, boolean coerceType) {
            super(AsmTypeConstants.OBJECT_TYPE);
            this.codegen = codegen;
            this.descriptor = descriptor;
            this.isSuper = isSuper;
            this.coerceType = coerceType;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            StackValue stackValue = this.codegen.generateThisOrOuter(this.descriptor, this.isSuper);
            stackValue.put(this.coerceType ? type : stackValue.type, v);
        }
    }

    public static class Composed
    extends StackValue {
        public final StackValue prefix;
        public final StackValue suffix;

        public Composed(StackValue prefix, StackValue suffix) {
            super(suffix.type);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.prefix.put(this.prefix.type, v);
            this.suffix.put(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.prefix.put(AsmTypeConstants.OBJECT_TYPE, v);
            this.suffix.store(topOfStackType, v);
        }
    }

    static class FieldForSharedVar
    extends StackValueWithSimpleReceiver {
        final JvmClassName owner;
        final String name;

        public FieldForSharedVar(Type type, JvmClassName owner, String name) {
            super(type, false);
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            Type sharedType = FieldForSharedVar.sharedTypeForType(this.type);
            Type refType = FieldForSharedVar.refType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "ref", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(181, FieldForSharedVar.sharedTypeForType(this.type).getInternalName(), "ref", FieldForSharedVar.refType(this.type).getDescriptor());
        }
    }

    public static class Shared
    extends StackValue {
        private final int index;
        private boolean isReleaseOnPut = false;

        public Shared(int index, Type type) {
            super(type);
            this.index = index;
        }

        public void releaseOnPut() {
            this.isReleaseOnPut = true;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.load(this.index, AsmTypeConstants.OBJECT_TYPE);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(180, sharedType.getInternalName(), "ref", refType.getDescriptor());
            this.coerceFrom(refType, v);
            this.coerceTo(type, v);
            if (this.isReleaseOnPut) {
                v.aconst(null);
                v.store(this.index, AsmTypeConstants.OBJECT_TYPE);
            }
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.load(this.index, AsmTypeConstants.OBJECT_TYPE);
            AsmUtil.swap(v, Shared.sharedTypeForType(this.type), topOfStackType);
            Type refType = Shared.refType(this.type);
            Type sharedType = Shared.sharedTypeForType(this.type);
            v.visitFieldInsn(181, sharedType.getInternalName(), "ref", refType.getDescriptor());
        }
    }

    private static class Expression
    extends StackValue {
        private final JetExpression expression;
        private final ExpressionCodegen generator;

        public Expression(Type type, JetExpression expression, ExpressionCodegen generator) {
            super(type);
            this.expression = expression;
            this.generator = generator;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.generator.gen(this.expression, type);
        }
    }

    static class Property
    extends StackValueWithSimpleReceiver {
        @Nullable
        private final CallableMethod getter;
        @Nullable
        private final CallableMethod setter;
        @NotNull
        public final JvmClassName methodOwner;
        @NotNull
        private final PropertyDescriptor descriptor;
        @NotNull
        private final GenerationState state;
        private final String name;

        public Property(@NotNull PropertyDescriptor descriptor, @NotNull JvmClassName methodOwner, @Nullable CallableMethod getter, @Nullable CallableMethod setter, boolean isStatic, @NotNull String name, @NotNull Type type, @NotNull GenerationState state) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            if (methodOwner == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "org/jetbrains/jet/codegen/StackValue$Property", "<init>"));
            }
            super(type, isStatic);
            this.methodOwner = methodOwner;
            this.getter = getter;
            this.setter = setter;
            this.descriptor = descriptor;
            this.state = state;
            this.name = name;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.getter == null) {
                v.visitFieldInsn(this.isStatic ? 178 : 180, this.methodOwner.getInternalName(), this.getPropertyName(), this.type.getDescriptor());
                AsmUtil.genNotNullAssertionForField(v, this.state, this.descriptor);
            } else {
                Method method = this.getter.getSignature().getAsmMethod();
                v.visitMethodInsn(this.getter.getInvokeOpcode(), this.getter.getOwner().getInternalName(), method.getName(), method.getDescriptor());
            }
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            if (this.setter == null) {
                v.visitFieldInsn(this.isStatic ? 179 : 181, this.methodOwner.getInternalName(), this.getPropertyName(), this.type.getDescriptor());
            } else {
                Method method = this.setter.getSignature().getAsmMethod();
                v.visitMethodInsn(this.setter.getInvokeOpcode(), this.setter.getOwner().getInternalName(), method.getName(), method.getDescriptor());
            }
        }

        private String getPropertyName() {
            return this.name;
        }
    }

    static class Field
    extends StackValueWithSimpleReceiver {
        final JvmClassName owner;
        final String name;

        public Field(Type type, JvmClassName owner, String name, boolean isStatic) {
            super(type, isStatic);
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.visitFieldInsn(this.isStatic ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.visitFieldInsn(this.isStatic ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }
    }

    private static class CollectionElement
    extends StackValue {
        private final Callable getter;
        private final Callable setter;
        private final ExpressionCodegen codegen;
        private final GenerationState state;
        private final FrameMap frame;
        private final ResolvedCall<FunctionDescriptor> resolvedGetCall;
        private final ResolvedCall<FunctionDescriptor> resolvedSetCall;
        private final FunctionDescriptor setterDescriptor;
        private final FunctionDescriptor getterDescriptor;

        public CollectionElement(Type type, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, ExpressionCodegen codegen, GenerationState state) {
            super(type);
            this.resolvedGetCall = resolvedGetCall;
            this.resolvedSetCall = resolvedSetCall;
            this.state = state;
            this.setterDescriptor = resolvedSetCall == null ? null : resolvedSetCall.getResultingDescriptor();
            this.getterDescriptor = resolvedGetCall == null ? null : resolvedGetCall.getResultingDescriptor();
            this.setter = resolvedSetCall == null ? null : codegen.resolveToCallable(this.setterDescriptor, false);
            this.getter = resolvedGetCall == null ? null : codegen.resolveToCallable(this.getterDescriptor, false);
            this.codegen = codegen;
            this.frame = codegen.myFrameMap;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.getter == null) {
                throw new UnsupportedOperationException("no getter specified");
            }
            if (this.getter instanceof CallableMethod) {
                ((CallableMethod)this.getter).invokeWithNotNullAssertion(v, this.state, this.resolvedGetCall);
            } else {
                ((IntrinsicMethod)this.getter).generate(this.codegen, v, type, null, null, null, this.state);
            }
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            if (this.setter == null) {
                throw new UnsupportedOperationException("no setter specified");
            }
            if (this.setter instanceof CallableMethod) {
                CallableMethod method = (CallableMethod)this.setter;
                Method asmMethod = method.getSignature().getAsmMethod();
                Type[] argumentTypes = asmMethod.getArgumentTypes();
                CollectionElement.coerce(topOfStackType, argumentTypes[argumentTypes.length - 1], v);
                method.invokeWithNotNullAssertion(v, this.state, this.resolvedSetCall);
                Type returnType = asmMethod.getReturnType();
                if (returnType != Type.VOID_TYPE) {
                    AsmUtil.pop(v, returnType);
                }
            } else {
                ((IntrinsicMethod)this.setter).generate(this.codegen, v, null, null, null, null, this.state);
            }
        }

        @Override
        public int receiverSize() {
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                return 2;
            }
            return -1;
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            if (this.isStandardStack(this.resolvedGetCall, 1) && this.isStandardStack(this.resolvedSetCall, 2)) {
                v.dup2();
            } else {
                int sz;
                Type type;
                int i;
                Type realReceiverType;
                int realReceiverIndex;
                int size = 0;
                int lastIndex = this.frame.enterTemp(Type.INT_TYPE);
                this.frame.leaveTemp(Type.INT_TYPE);
                List<ValueParameterDescriptor> valueParameters = this.resolvedGetCall.getResultingDescriptor().getValueParameters();
                int firstParamIndex = -1;
                for (int i2 = valueParameters.size() - 1; i2 >= 0; --i2) {
                    Type type2 = this.codegen.typeMapper.mapType(valueParameters.get(i2).getType());
                    int sz2 = type2.getSize();
                    this.frame.enterTemp(type2);
                    size += sz2;
                    firstParamIndex = lastIndex += sz2;
                    v.store(firstParamIndex - sz2, type2);
                }
                List<TypeParameterDescriptor> typeParameters = this.resolvedGetCall.getResultingDescriptor().getTypeParameters();
                int firstTypeParamIndex = -1;
                for (int i3 = typeParameters.size() - 1; i3 >= 0; --i3) {
                    if (!typeParameters.get(i3).isReified()) continue;
                    this.frame.enterTemp(AsmTypeConstants.OBJECT_TYPE);
                    ++size;
                    firstTypeParamIndex = ++lastIndex - 1;
                    v.store(firstTypeParamIndex, AsmTypeConstants.OBJECT_TYPE);
                }
                ReceiverValue receiverParameter = this.resolvedGetCall.getReceiverArgument();
                int receiverIndex = -1;
                if (receiverParameter.exists()) {
                    Type type3 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                    int sz3 = type3.getSize();
                    this.frame.enterTemp(type3);
                    size += sz3;
                    receiverIndex = lastIndex += sz3;
                    v.store(receiverIndex - sz3, type3);
                }
                ReceiverValue thisObject = this.resolvedGetCall.getThisObject();
                int thisIndex = -1;
                if (thisObject.exists()) {
                    this.frame.enterTemp(AsmTypeConstants.OBJECT_TYPE);
                    ++size;
                    thisIndex = ++lastIndex;
                    v.store(thisIndex - 1, AsmTypeConstants.OBJECT_TYPE);
                }
                if (thisIndex != -1) {
                    if (receiverIndex != -1) {
                        realReceiverIndex = receiverIndex;
                        realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                    } else {
                        realReceiverIndex = thisIndex;
                        realReceiverType = AsmTypeConstants.OBJECT_TYPE;
                    }
                } else if (receiverIndex != -1) {
                    realReceiverType = this.codegen.typeMapper.mapType(receiverParameter.getType());
                    realReceiverIndex = receiverIndex;
                } else {
                    throw new UnsupportedOperationException();
                }
                if (this.resolvedSetCall.getThisObject().exists()) {
                    if (this.resolvedSetCall.getReceiverArgument().exists()) {
                        this.codegen.generateFromResolvedCall(this.resolvedSetCall.getThisObject(), AsmTypeConstants.OBJECT_TYPE);
                    }
                    v.load(realReceiverIndex - realReceiverType.getSize(), realReceiverType);
                } else if (this.resolvedSetCall.getReceiverArgument().exists()) {
                    v.load(realReceiverIndex - realReceiverType.getSize(), realReceiverType);
                } else {
                    throw new UnsupportedOperationException();
                }
                int index = firstParamIndex;
                for (i = 0; i != valueParameters.size(); ++i) {
                    type = this.codegen.typeMapper.mapType(valueParameters.get(i).getType());
                    sz = type.getSize();
                    v.load(index - sz, type);
                    index -= sz;
                }
                if (thisIndex != -1) {
                    v.load(thisIndex - 1, AsmTypeConstants.OBJECT_TYPE);
                }
                if (receiverIndex != -1) {
                    Type type4 = this.codegen.typeMapper.mapType(receiverParameter.getType());
                    v.load(receiverIndex - type4.getSize(), type4);
                }
                if (firstTypeParamIndex != -1) {
                    index = firstTypeParamIndex;
                    for (i = 0; i != typeParameters.size(); ++i) {
                        if (!typeParameters.get(i).isReified()) continue;
                        v.load(index - 1, AsmTypeConstants.OBJECT_TYPE);
                        --index;
                    }
                }
                index = firstParamIndex;
                for (i = 0; i != valueParameters.size(); ++i) {
                    type = this.codegen.typeMapper.mapType(valueParameters.get(i).getType());
                    sz = type.getSize();
                    v.load(index - sz, type);
                    index -= sz;
                }
                for (i = 0; i < size; ++i) {
                    this.frame.leaveTemp(AsmTypeConstants.OBJECT_TYPE);
                }
            }
        }

        private boolean isStandardStack(ResolvedCall call, int valueParamsSize) {
            if (call == null) {
                return true;
            }
            for (TypeParameterDescriptor typeParameterDescriptor : call.getResultingDescriptor().getTypeParameters()) {
                if (!typeParameterDescriptor.isReified()) continue;
                return false;
            }
            List<ValueParameterDescriptor> valueParameters = call.getResultingDescriptor().getValueParameters();
            if (valueParameters.size() != valueParamsSize) {
                return false;
            }
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (this.codegen.typeMapper.mapType(valueParameter.getType()).getSize() == 1) continue;
                return false;
            }
            return !(call.getThisObject().exists() ? call.getReceiverArgument().exists() : this.codegen.typeMapper.mapType(call.getResultingDescriptor().getReceiverParameter().getType()).getSize() != 1);
        }
    }

    private static class ArrayElement
    extends StackValue {
        private final Type boxed;

        public ArrayElement(Type type, boolean unbox) {
            super(type);
            this.boxed = unbox ? AsmUtil.boxType(type) : type;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.aload(this.boxed);
            ArrayElement.coerce(this.boxed, type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            ArrayElement.coerce(topOfStackType, this.boxed, v);
            v.astore(this.boxed);
        }

        @Override
        public void dupReceiver(InstructionAdapter v) {
            v.dup2();
        }

        @Override
        public int receiverSize() {
            return 2;
        }
    }

    private static class Invert
    extends StackValue {
        private final StackValue myOperand;

        private Invert(StackValue operand) {
            super(Type.BOOLEAN_TYPE);
            this.myOperand = operand;
            if (this.myOperand.type != Type.BOOLEAN_TYPE) {
                throw new UnsupportedOperationException("operand of ! must be boolean");
            }
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.putAsBoolean(v);
            this.coerceTo(type, v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            this.myOperand.condJump(label, !jumpIfFalse, v);
        }
    }

    private static class ObjectCompare
    extends NumberCompare {
        public ObjectCompare(IElementType opToken, Type operandType) {
            super(opToken, operandType);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            int opcode;
            if (this.opToken == JetTokens.EQEQEQ) {
                opcode = jumpIfFalse ? 166 : 165;
            } else if (this.opToken == JetTokens.EXCLEQEQEQ) {
                opcode = jumpIfFalse ? 165 : 166;
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    private static class NumberCompare
    extends StackValue {
        protected final IElementType opToken;
        private final Type operandType;

        public NumberCompare(IElementType opToken, Type operandType) {
            super(Type.BOOLEAN_TYPE);
            this.opToken = opToken;
            this.operandType = operandType;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.putAsBoolean(v);
            this.coerceTo(type, v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            int opcode;
            if (this.opToken == JetTokens.EQEQ) {
                opcode = jumpIfFalse ? 154 : 153;
            } else if (this.opToken == JetTokens.EXCLEQ) {
                opcode = jumpIfFalse ? 153 : 154;
            } else if (this.opToken == JetTokens.GT) {
                opcode = jumpIfFalse ? 158 : 157;
            } else if (this.opToken == JetTokens.GTEQ) {
                opcode = jumpIfFalse ? 155 : 156;
            } else if (this.opToken == JetTokens.LT) {
                opcode = jumpIfFalse ? 156 : 155;
            } else if (this.opToken == JetTokens.LTEQ) {
                opcode = jumpIfFalse ? 157 : 158;
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
            if (this.operandType == Type.FLOAT_TYPE || this.operandType == Type.DOUBLE_TYPE) {
                if (this.opToken == JetTokens.GT || this.opToken == JetTokens.GTEQ) {
                    v.cmpg(this.operandType);
                } else {
                    v.cmpl(this.operandType);
                }
            } else if (this.operandType == Type.LONG_TYPE) {
                v.lcmp();
            } else {
                opcode += 6;
            }
            v.visitJumpInsn(opcode, label);
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        private final Object value;

        public Constant(@Nullable Object value, Type type) {
            super(type);
            this.value = value;
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            if (this.value instanceof Integer) {
                v.iconst((Integer)this.value);
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            this.coerceTo(type, v);
        }

        @Override
        public void condJump(Label label, boolean jumpIfFalse, InstructionAdapter v) {
            if (this.value instanceof Boolean) {
                boolean boolValue = (Boolean)this.value;
                if (boolValue ^ jumpIfFalse) {
                    v.goTo(label);
                }
            } else {
                throw new UnsupportedOperationException("don't know how to generate this condjump");
            }
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type) {
            super(type);
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.coerceTo(type, v);
        }

        @Override
        public void moveToTopOfStack(Type type, InstructionAdapter v, int depth) {
            if (depth == 0) {
                this.put(type, v);
            } else if (depth == 1) {
                if (type.getSize() != 1) {
                    throw new UnsupportedOperationException("don't know how to move type " + type + " to top of stack");
                }
                v.swap();
            } else {
                throw new UnsupportedOperationException("unsupported move-to-top depth " + depth);
            }
        }
    }

    public static class Local
    extends StackValue {
        final int index;

        public Local(int index, Type type) {
            super(type);
            this.index = index;
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            v.load(this.index, this.type);
            this.coerceTo(type, v);
        }

        @Override
        public void store(Type topOfStackType, InstructionAdapter v) {
            this.coerceFrom(topOfStackType, v);
            v.store(this.index, this.type);
        }
    }

    private static class None
    extends StackValue {
        public static final None INSTANCE = new None();

        private None() {
            super(Type.VOID_TYPE);
        }

        @Override
        public void put(Type type, InstructionAdapter v) {
            this.coerceTo(type, v);
        }
    }
}

