/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedMemberScope;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorForObjectImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.NullableLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.InnerClassesScopeWrapper;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DeserializedClassDescriptor
extends AbstractClassDescriptor
implements ClassDescriptor {
    private final ClassId classId;
    private final ProtoBuf.Class classProto;
    private final TypeDeserializer typeDeserializer;
    private final DescriptorDeserializer deserializer;
    private final DeserializedMemberScope memberScope;
    private final ReceiverParameterDescriptor thisAsReceiverParameter;
    private final NullableLazyValue<ConstructorDescriptor> primaryConstructor;
    private final AnnotationDeserializer annotationDeserializer;
    private final NotNullLazyValue<List<AnnotationDescriptor>> annotations;
    private final NullableLazyValue<ClassDescriptor> classObjectDescriptor;
    private final NestedClassDescriptors nestedClasses;
    private final NestedClassDescriptors nestedObjects;
    private final NotNullLazyValue<DeclarationDescriptor> containingDeclaration;
    private final DeserializedClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final InnerClassesScopeWrapper innerClassesScope;
    private final DescriptorFinder descriptorFinder;

    public DeserializedClassDescriptor(@NotNull StorageManager storageManager, @NotNull AnnotationDeserializer annotationResolver, @NotNull DescriptorFinder descriptorFinder, @NotNull ClassData classData) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (descriptorFinder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        super(classData.getNameResolver().getClassId(classData.getClassProto().getFqName()).getRelativeClassName().shortName());
        NameResolver nameResolver = classData.getNameResolver();
        this.classProto = classData.getClassProto();
        this.classId = nameResolver.getClassId(this.classProto.getFqName());
        this.descriptorFinder = descriptorFinder;
        TypeDeserializer notNullTypeDeserializer = new TypeDeserializer(storageManager, null, nameResolver, descriptorFinder, "Deserializer for class " + this.name, TypeDeserializer.TypeParameterResolver.NONE);
        DescriptorDeserializer outerDeserializer = DescriptorDeserializer.create(storageManager, notNullTypeDeserializer, this, nameResolver, annotationResolver);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(this.classProto.getTypeParameterCount());
        this.deserializer = outerDeserializer.createChildDeserializer(this, this.classProto.getTypeParameterList(), typeParameters);
        this.typeDeserializer = this.deserializer.getTypeDeserializer();
        this.containingDeclaration = storageManager.createLazyValue(new Computable<DeclarationDescriptor>(){

            @Override
            public DeclarationDescriptor compute() {
                return DeserializedClassDescriptor.this.computeContainingDeclaration();
            }
        });
        this.typeConstructor = new DeserializedClassTypeConstructor(typeParameters);
        this.memberScope = new DeserializedClassMemberScope(storageManager, this);
        this.innerClassesScope = new InnerClassesScopeWrapper(this.memberScope);
        this.thisAsReceiverParameter = new LazyClassReceiverParameterDescriptor();
        int flags = this.classProto.getFlags();
        this.modality = DescriptorDeserializer.modality(Flags.MODALITY.get(flags));
        this.visibility = DescriptorDeserializer.visibility(Flags.VISIBILITY.get(flags));
        this.kind = DescriptorDeserializer.classKind(Flags.CLASS_KIND.get(flags));
        this.isInner = Flags.INNER.get(flags);
        this.annotationDeserializer = annotationResolver;
        this.annotations = storageManager.createLazyValue(new Computable<List<AnnotationDescriptor>>(){

            @Override
            public List<AnnotationDescriptor> compute() {
                return DeserializedClassDescriptor.this.computeAnnotations();
            }
        });
        this.primaryConstructor = storageManager.createNullableLazyValue(new Computable<ConstructorDescriptor>(){

            @Override
            public ConstructorDescriptor compute() {
                return DeserializedClassDescriptor.this.computePrimaryConstructor();
            }
        });
        this.classObjectDescriptor = storageManager.createNullableLazyValue(new Computable<ClassDescriptor>(){

            @Override
            public ClassDescriptor compute() {
                return DeserializedClassDescriptor.this.computeClassObjectDescriptor();
            }
        });
        this.nestedClasses = new NestedClassDescriptors(storageManager, DeserializedClassDescriptor.names(this.classProto.getNestedClassNameList(), nameResolver));
        this.nestedObjects = new NestedClassDescriptors(storageManager, DeserializedClassDescriptor.names(this.classProto.getNestedObjectNameList(), nameResolver));
    }

    @NotNull
    private static Set<Name> names(@NotNull List<Integer> nameIndices, @NotNull NameResolver nameResolver) {
        if (nameIndices == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "names"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "names"));
        }
        HashSet<Name> result = new HashSet<Name>(nameIndices.size());
        for (Integer index : nameIndices) {
            result.add(nameResolver.getName(index));
        }
        HashSet<Name> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "names"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.containingDeclaration.compute();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private DeclarationDescriptor computeContainingDeclaration() {
        ClassOrNamespaceDescriptor result = this.classId.isTopLevelClass() ? this.descriptorFinder.findPackage(this.classId.getPackageFqName()) : this.descriptorFinder.findClass(this.classId.getOuterClassId());
        DeclarationDescriptor declarationDescriptor = result != null ? result : ErrorUtils.getErrorModule();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "computeContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        DeserializedClassTypeConstructor deserializedClassTypeConstructor = this.typeConstructor;
        if (deserializedClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getTypeConstructor"));
        }
        return deserializedClassTypeConstructor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    private List<AnnotationDescriptor> computeAnnotations() {
        if (!Flags.HAS_ANNOTATIONS.get(this.classProto.getFlags()).booleanValue()) {
            return Collections.emptyList();
        }
        return this.annotationDeserializer.loadClassAnnotations(this, this.classProto);
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations.compute();
    }

    @Override
    protected JetScope getScopeForMemberLookup() {
        return this.memberScope;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        InnerClassesScopeWrapper innerClassesScopeWrapper = this.innerClassesScope;
        if (innerClassesScopeWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getUnsubstitutedInnerClassesScope"));
        }
        return innerClassesScopeWrapper;
    }

    @Nullable
    private ConstructorDescriptor computePrimaryConstructor() {
        if (!this.classProto.hasPrimaryConstructor()) {
            return null;
        }
        ProtoBuf.Callable constructorProto = this.classProto.getPrimaryConstructor();
        return (ConstructorDescriptor)this.deserializer.loadCallable(constructorProto);
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor.compute();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        ConstructorDescriptor constructor = this.getUnsubstitutedPrimaryConstructor();
        if (constructor == null) {
            List<ConstructorDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getConstructors"));
            }
            return list;
        }
        List<ConstructorDescriptor> list = Collections.singletonList(constructor);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getConstructors"));
        }
        return list;
    }

    @Override
    @Nullable
    public JetType getClassObjectType() {
        ClassDescriptor classObjectDescriptor = this.getClassObjectDescriptor();
        return classObjectDescriptor == null ? null : classObjectDescriptor.getDefaultType();
    }

    @Nullable
    private ClassDescriptor computeClassObjectDescriptor() {
        if (!this.classProto.getClassObjectPresent()) {
            return null;
        }
        if (this.getKind() == ClassKind.ENUM_CLASS) {
            MutableClassDescriptor classObject = this.createEnumClassObject();
            for (int enumEntry : this.classProto.getEnumEntryList()) {
                this.createEnumEntry(classObject, this.deserializer.getNameResolver().getName(enumEntry));
            }
            return classObject;
        }
        return this.descriptorFinder.findClass(this.classId.createNestedClassId(DescriptorUtils.getClassObjectName(this.getName())));
    }

    @NotNull
    private MutableClassDescriptor createEnumClassObject() {
        MutableClassDescriptor classObject = new MutableClassDescriptor(this, this.getScopeForMemberLookup(), ClassKind.CLASS_OBJECT, false, DescriptorUtils.getClassObjectName(this.getName()));
        classObject.setModality(Modality.FINAL);
        classObject.setVisibility(this.getVisibility());
        classObject.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        classObject.createTypeConstructor();
        ConstructorDescriptorImpl primaryConstructor = DescriptorFactory.createPrimaryConstructorForObject(classObject);
        primaryConstructor.setReturnType(classObject.getDefaultType());
        classObject.setPrimaryConstructor(primaryConstructor);
        JetType defaultType = this.getDefaultType();
        JetType defaultTypeArray = KotlinBuiltIns.getInstance().getArrayType(defaultType);
        classObject.getBuilder().addFunctionDescriptor(DescriptorFactory.createEnumClassObjectValuesMethod(classObject, defaultTypeArray));
        classObject.getBuilder().addFunctionDescriptor(DescriptorFactory.createEnumClassObjectValueOfMethod(classObject, defaultType));
        MutableClassDescriptor mutableClassDescriptor = classObject;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "createEnumClassObject"));
        }
        return mutableClassDescriptor;
    }

    private void createEnumEntry(@NotNull MutableClassDescriptor enumClassObject, @NotNull Name name) {
        if (enumClassObject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "createEnumEntry"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "createEnumEntry"));
        }
        PropertyDescriptorForObjectImpl property = new PropertyDescriptorForObjectImpl(enumClassObject, Collections.<AnnotationDescriptor>emptyList(), Visibilities.PUBLIC, name, this);
        property.setType(this.getDefaultType(), Collections.emptyList(), enumClassObject.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        PropertyGetterDescriptorImpl getter = DescriptorFactory.createDefaultGetter(property);
        getter.initialize(property.getReturnType());
        property.initialize(getter, null);
        enumClassObject.getBuilder().addPropertyDescriptor(property);
    }

    @Override
    @Nullable
    public ClassDescriptor getClassObjectDescriptor() {
        return this.classObjectDescriptor.compute();
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        ReceiverParameterDescriptor receiverParameterDescriptor = this.thisAsReceiverParameter;
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getThisAsReceiverParameter"));
        }
        return receiverParameterDescriptor;
    }

    private Collection<JetType> computeSuperTypes() {
        ArrayList<JetType> supertypes = new ArrayList<JetType>(this.classProto.getSupertypeCount());
        for (ProtoBuf.Type supertype : this.classProto.getSupertypeList()) {
            supertypes.add(this.typeDeserializer.type(supertype));
        }
        return supertypes;
    }

    public String toString() {
        return "deserialized class " + this.getName().toString();
    }

    private class LazyClassReceiverParameterDescriptor
    extends AbstractReceiverParameterDescriptor {
        private final ClassReceiver classReceiver;

        private LazyClassReceiverParameterDescriptor() {
            this.classReceiver = new ClassReceiver(DeserializedClassDescriptor.this);
        }

        @Override
        @NotNull
        public JetType getType() {
            JetType jetType = DeserializedClassDescriptor.this.getDefaultType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$LazyClassReceiverParameterDescriptor", "getType"));
            }
            return jetType;
        }

        @Override
        @NotNull
        public ReceiverValue getValue() {
            ClassReceiver classReceiver = this.classReceiver;
            if (classReceiver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$LazyClassReceiverParameterDescriptor", "getValue"));
            }
            return classReceiver;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            DeserializedClassDescriptor deserializedClassDescriptor = DeserializedClassDescriptor.this;
            if (deserializedClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$LazyClassReceiverParameterDescriptor", "getContainingDeclaration"));
            }
            return deserializedClassDescriptor;
        }
    }

    private class NestedClassDescriptors {
        private final Set<Name> declaredNames;
        private final MemoizedFunctionToNullable<Name, ClassDescriptor> findClass;

        public NestedClassDescriptors(@NotNull StorageManager storageManager, @NotNull Set<Name> declaredNames) {
            if (storageManager == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "<init>"));
            }
            if (declaredNames == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "<init>"));
            }
            this.declaredNames = declaredNames;
            this.findClass = storageManager.createMemoizedFunctionWithNullableValues(new Function<Name, ClassDescriptor>(){

                @Override
                public ClassDescriptor fun(Name name) {
                    return NestedClassDescriptors.this.declaredNames.contains(name) ? DeserializedClassDescriptor.this.descriptorFinder.findClass(DeserializedClassDescriptor.this.classId.createNestedClassId(name)) : null;
                }
            }, StorageManager.ReferenceKind.STRONG);
        }

        @NotNull
        public Collection<ClassDescriptor> getAllDescriptors() {
            ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(this.declaredNames.size());
            for (Name name : this.declaredNames) {
                ClassDescriptor descriptor = this.findClass.fun(name);
                if (descriptor == null) continue;
                result.add(descriptor);
            }
            ArrayList<ClassDescriptor> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "getAllDescriptors"));
            }
            return arrayList;
        }
    }

    private static class DeserializedClassMemberScope
    extends DeserializedMemberScope {
        private final DeserializedClassDescriptor classDescriptor;

        public DeserializedClassMemberScope(@NotNull StorageManager storageManager, @NotNull DeserializedClassDescriptor classDescriptor) {
            if (storageManager == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "<init>"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "<init>"));
            }
            super(storageManager, classDescriptor, classDescriptor.deserializer, classDescriptor.classProto.getMemberList());
            this.classDescriptor = classDescriptor;
        }

        @Override
        protected void computeNonDeclaredFunctions(@NotNull Name name, @NotNull Collection<FunctionDescriptor> functions) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredFunctions"));
            }
            if (functions == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredFunctions"));
            }
            ArrayList<FunctionDescriptor> fromSupertypes = new ArrayList<FunctionDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getFunctions(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, functions);
        }

        @Override
        protected void computeNonDeclaredProperties(@NotNull Name name, @NotNull Collection<PropertyDescriptor> property) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredProperties"));
            }
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredProperties"));
            }
            ArrayList<VariableDescriptor> fromSupertypes = new ArrayList<VariableDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getProperties(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, property);
        }

        private <D extends CallableMemberDescriptor> void generateFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes, final @NotNull Collection<D> result) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            if (fromSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            ArrayList<D> fromCurrent = new ArrayList<D>(result);
            OverridingUtil.generateOverridesInFunctionGroup(name, fromSupertypes, fromCurrent, this.classDescriptor, new OverridingUtil.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "addToScope"));
                    }
                    OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new OverridingUtil.NotInferredVisibilitySink(){

                        @Override
                        public void cannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
                            if (descriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1$1", "cannotInferVisibility"));
                            }
                        }
                    });
                    result.add(fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    if (fromSuper == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "conflict"));
                    }
                    if (fromCurrent == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "conflict"));
                    }
                }
            });
        }

        @Override
        protected void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "addNonDeclaredDescriptors"));
            }
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                    if (descriptor instanceof FunctionDescriptor) {
                        result.addAll(this.getFunctions(descriptor.getName()));
                        continue;
                    }
                    if (!(descriptor instanceof PropertyDescriptor)) continue;
                    result.addAll(this.getProperties(descriptor.getName()));
                }
            }
        }

        @Override
        @Nullable
        protected ReceiverParameterDescriptor getImplicitReceiver() {
            return this.classDescriptor.getThisAsReceiverParameter();
        }

        @Override
        @Nullable
        protected ClassifierDescriptor getClassDescriptor(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "getClassDescriptor"));
            }
            return (ClassifierDescriptor)this.classDescriptor.nestedClasses.findClass.fun(name);
        }

        @Override
        protected void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "addAllClassDescriptors"));
            }
            result.addAll(this.classDescriptor.nestedClasses.getAllDescriptors());
        }

        @Override
        @Nullable
        public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "getObjectDescriptor"));
            }
            return (ClassDescriptor)this.classDescriptor.nestedObjects.findClass.fun(name);
        }

        @Override
        @NotNull
        protected Collection<ClassDescriptor> computeAllObjectDescriptors() {
            Collection<ClassDescriptor> collection = this.classDescriptor.nestedObjects.getAllDescriptors();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeAllObjectDescriptors"));
            }
            return collection;
        }
    }

    private class DeserializedClassTypeConstructor
    implements TypeConstructor {
        private final Collection<JetType> supertypes;
        private final List<TypeParameterDescriptor> parameters;

        public DeserializedClassTypeConstructor(@NotNull List<TypeParameterDescriptor> typeParameters) {
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "<init>"));
            }
            this.supertypes = DeserializedClassDescriptor.this.computeSuperTypes();
            this.parameters = typeParameters;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List<TypeParameterDescriptor> list = this.parameters;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            Collection<JetType> collection = this.supertypes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        @Override
        public boolean isSealed() {
            return !DeserializedClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return DeserializedClassDescriptor.this;
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            return Collections.emptyList();
        }

        public String toString() {
            return DeserializedClassDescriptor.this.getName().toString();
        }
    }
}

