/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public abstract class DeserializedMemberScope
implements JetScope {
    private static final Filter<ProtoBuf.Callable.CallableKind> FUNCTION = new Filter<ProtoBuf.Callable.CallableKind>(){

        @Override
        public boolean accept(ProtoBuf.Callable.CallableKind value) {
            return value == ProtoBuf.Callable.CallableKind.FUN;
        }
    };
    private static final Filter<ProtoBuf.Callable.CallableKind> PROPERTY = new Filter<ProtoBuf.Callable.CallableKind>(){

        @Override
        public boolean accept(ProtoBuf.Callable.CallableKind value) {
            return value == ProtoBuf.Callable.CallableKind.VAL || value == ProtoBuf.Callable.CallableKind.VAR || value == ProtoBuf.Callable.CallableKind.OBJECT_PROPERTY;
        }
    };
    private final DeclarationDescriptor containingDeclaration;
    private final DescriptorDeserializer deserializer;
    private final Map<Name, List<ProtoBuf.Callable>> membersProtos;
    private final MemoizedFunctionToNotNull<Name, Collection<FunctionDescriptor>> functions;
    private final MemoizedFunctionToNotNull<Name, Collection<VariableDescriptor>> properties;
    private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;
    private final NotNullLazyValue<Collection<ClassDescriptor>> objectDescriptors;

    public DeserializedMemberScope(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull DescriptorDeserializer deserializer, @NotNull List<ProtoBuf.Callable> membersList) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        if (deserializer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        if (membersList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        this.containingDeclaration = containingDeclaration;
        this.deserializer = deserializer;
        this.membersProtos = this.groupByName(membersList);
        this.functions = storageManager.createMemoizedFunction(new Function<Name, Collection<FunctionDescriptor>>(){

            @Override
            public Collection<FunctionDescriptor> fun(Name name) {
                return DeserializedMemberScope.this.computeFunctions(name);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.properties = storageManager.createMemoizedFunction(new Function<Name, Collection<VariableDescriptor>>(){

            @Override
            public Collection<VariableDescriptor> fun(Name name) {
                return DeserializedMemberScope.this.computeProperties(name);
            }
        }, StorageManager.ReferenceKind.STRONG);
        this.allDescriptors = storageManager.createLazyValue(new Computable<Collection<DeclarationDescriptor>>(){

            @Override
            public Collection<DeclarationDescriptor> compute() {
                return DeserializedMemberScope.this.computeAllDescriptors();
            }
        });
        this.objectDescriptors = storageManager.createLazyValue(new Computable<Collection<ClassDescriptor>>(){

            @Override
            public Collection<ClassDescriptor> compute() {
                return DeserializedMemberScope.this.computeAllObjectDescriptors();
            }
        });
    }

    @NotNull
    private Map<Name, List<ProtoBuf.Callable>> groupByName(@NotNull Collection<ProtoBuf.Callable> membersList) {
        if (membersList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "groupByName"));
        }
        HashMap<Name, List<ProtoBuf.Callable>> map = new HashMap<Name, List<ProtoBuf.Callable>>();
        for (ProtoBuf.Callable memberProto : membersList) {
            Name name = this.deserializer.getNameResolver().getName(memberProto.getName());
            ArrayList<ProtoBuf.Callable> protos = (ArrayList<ProtoBuf.Callable>)map.get(name);
            if (protos == null) {
                protos = new ArrayList<ProtoBuf.Callable>(1);
                map.put(name, protos);
            }
            protos.add(memberProto);
        }
        HashMap<Name, List<ProtoBuf.Callable>> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "groupByName"));
        }
        return hashMap;
    }

    @NotNull
    private <D extends CallableMemberDescriptor> Collection<D> computeMembersByName(Name name, Filter<ProtoBuf.Callable.CallableKind> callableKind) {
        List<ProtoBuf.Callable> memberProtos = this.membersProtos.get(name);
        LinkedHashSet<CallableMemberDescriptor> descriptors = new LinkedHashSet<CallableMemberDescriptor>(memberProtos != null ? memberProtos.size() : 0);
        if (memberProtos != null) {
            for (ProtoBuf.Callable memberProto : memberProtos) {
                if (!callableKind.accept(Flags.CALLABLE_KIND.get(memberProto.getFlags()))) continue;
                descriptors.add(this.deserializer.loadCallable(memberProto));
            }
        }
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = descriptors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeMembersByName"));
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<FunctionDescriptor> computeFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeFunctions"));
        }
        Collection<FunctionDescriptor> descriptors = this.computeMembersByName(name, FUNCTION);
        this.computeNonDeclaredFunctions(name, descriptors);
        Collection<FunctionDescriptor> collection = descriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeFunctions"));
        }
        return collection;
    }

    protected void computeNonDeclaredFunctions(@NotNull Name name, @NotNull Collection<FunctionDescriptor> functions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredFunctions"));
        }
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredFunctions"));
        }
    }

    @Override
    @NotNull
    public final Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getFunctions"));
        }
        Collection<FunctionDescriptor> collection = this.functions.fun(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getFunctions"));
        }
        return collection;
    }

    @NotNull
    private Collection<VariableDescriptor> computeProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeProperties"));
        }
        Collection<VariableDescriptor> descriptors = this.computeMembersByName(name, PROPERTY);
        this.computeNonDeclaredProperties(name, descriptors);
        Collection<VariableDescriptor> collection = descriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeProperties"));
        }
        return collection;
    }

    protected void computeNonDeclaredProperties(@NotNull Name name, @NotNull Collection<PropertyDescriptor> descriptors) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredProperties"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredProperties"));
        }
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getProperties"));
        }
        Collection<VariableDescriptor> collection = this.properties.fun(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getProperties"));
        }
        return collection;
    }

    @Override
    @Nullable
    public final ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getClassifier"));
        }
        return this.getClassDescriptor(name);
    }

    @Nullable
    protected abstract ClassifierDescriptor getClassDescriptor(@NotNull Name var1);

    protected abstract void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @Nullable
    public abstract ClassDescriptor getObjectDescriptor(@NotNull Name var1);

    @NotNull
    protected abstract Collection<ClassDescriptor> computeAllObjectDescriptors();

    @Override
    @NotNull
    public Collection<ClassDescriptor> getObjectDescriptors() {
        Collection<ClassDescriptor> collection = this.objectDescriptors.compute();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getObjectDescriptors"));
        }
        return collection;
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getNamespace"));
        }
        return null;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getLocalVariable"));
        }
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.containingDeclaration;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getDeclarationsByLabel"));
        }
        throw new UnsupportedOperationException("Should not be called");
    }

    private Collection<DeclarationDescriptor> computeAllDescriptors() {
        LinkedHashSet<DeclarationDescriptor> result = new LinkedHashSet<DeclarationDescriptor>(0);
        for (Name name : this.membersProtos.keySet()) {
            result.addAll(this.getFunctions(name));
            result.addAll(this.getProperties(name));
        }
        this.addNonDeclaredDescriptors(result);
        this.addAllClassDescriptors(result);
        return result;
    }

    protected abstract void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @NotNull
    public final Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection<DeclarationDescriptor> collection = this.allDescriptors.compute();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        ReceiverParameterDescriptor receiver = this.getImplicitReceiver();
        if (receiver != null) {
            List<ReceiverParameterDescriptor> list = Collections.singletonList(receiver);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getImplicitReceiversHierarchy"));
            }
            return list;
        }
        List<ReceiverParameterDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getImplicitReceiversHierarchy"));
        }
        return list;
    }

    @Nullable
    protected abstract ReceiverParameterDescriptor getImplicitReceiver();

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        Collection<DeclarationDescriptor> collection = this.getAllDescriptors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getOwnDeclaredDescriptors"));
        }
        return collection;
    }

    private static interface Filter<T> {
        public boolean accept(T var1);
    }
}

