/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractLazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DeserializedTypeParameterDescriptor
extends AbstractLazyTypeParameterDescriptor {
    private final ProtoBuf.TypeParameter proto;
    private final TypeDeserializer typeDeserializer;

    public DeserializedTypeParameterDescriptor(@NotNull StorageManager storageManager, @NotNull TypeDeserializer typeDeserializer, @NotNull ProtoBuf.TypeParameter proto, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull Variance variance, boolean isReified, int index) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (typeDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "<init>"));
        }
        super(storageManager, containingDeclaration, name, variance, isReified, index);
        this.proto = proto;
        this.typeDeserializer = typeDeserializer;
    }

    @Override
    @NotNull
    protected Set<JetType> resolveUpperBounds() {
        LinkedHashSet<JetType> result = new LinkedHashSet<JetType>(this.proto.getUpperBoundCount());
        for (ProtoBuf.Type upperBound : this.proto.getUpperBoundList()) {
            result.add(this.typeDeserializer.type(upperBound));
        }
        if (result.isEmpty()) {
            result.add(KotlinBuiltIns.getInstance().getDefaultBound());
        }
        LinkedHashSet<JetType> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedTypeParameterDescriptor", "resolveUpperBounds"));
        }
        return linkedHashSet;
    }

    public int getProtoId() {
        return this.proto.getId();
    }
}

