/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;

public abstract class InstructionImpl
implements Instruction {
    private Pseudocode owner;
    private final Collection<Instruction> previousInstructions = new LinkedHashSet<Instruction>();
    private final Collection<Instruction> copies = Sets.newHashSet();
    private Instruction original;
    protected boolean isDead = false;

    protected InstructionImpl() {
    }

    @Override
    @NotNull
    public Pseudocode getOwner() {
        Pseudocode pseudocode = this.owner;
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "getOwner"));
        }
        return pseudocode;
    }

    @Override
    public void setOwner(@NotNull Pseudocode owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "setOwner"));
        }
        assert (this.owner == null || this.owner == owner);
        this.owner = owner;
    }

    @Override
    @NotNull
    public Collection<Instruction> getPreviousInstructions() {
        Collection<Instruction> collection = this.previousInstructions;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "getPreviousInstructions"));
        }
        return collection;
    }

    @Nullable
    protected Instruction outgoingEdgeTo(@Nullable Instruction target) {
        if (target != null) {
            target.getPreviousInstructions().add(this);
        }
        return target;
    }

    public void die() {
        this.isDead = true;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public final Instruction copy() {
        return this.updateCopyInfo(this.createCopy());
    }

    protected abstract Instruction createCopy();

    @Override
    @NotNull
    public Collection<Instruction> getCopies() {
        if (this.original != null) {
            HashSet<Instruction> originalCopies = Sets.newHashSet(this.original.getCopies());
            originalCopies.remove(this);
            originalCopies.add(this.original);
            HashSet<Instruction> hashSet = originalCopies;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "getCopies"));
            }
            return hashSet;
        }
        Collection<Instruction> collection = this.copies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "getCopies"));
        }
        return collection;
    }

    private void addCopy(@NotNull Instruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "addCopy"));
        }
        this.copies.add(instruction);
    }

    private void setOriginal(@NotNull Instruction original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "setOriginal"));
        }
        assert (this.original == null) : "Instruction can't have two originals: this.original = " + this.original + "; new original = " + original;
        this.original = original;
    }

    protected Instruction updateCopyInfo(@NotNull Instruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/cfg/pseudocode/InstructionImpl", "updateCopyInfo"));
        }
        this.addCopy(instruction);
        ((InstructionImpl)instruction).setOriginal(this);
        return instruction;
    }
}

