/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    private NamespaceDescriptor rootNamepsace;
    private ModuleConfiguration moduleConfiguration;
    private final List<ImportPath> defaultImports;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;

    public ModuleDescriptorImpl(@NotNull Name name, @NotNull List<ImportPath> defaultImports, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "<init>"));
        }
        if (defaultImports == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "<init>"));
        }
        if (platformToKotlinClassMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "<init>"));
        }
        super(Collections.<AnnotationDescriptor>emptyList(), name);
        if (!name.isSpecial()) {
            throw new IllegalArgumentException("module name must be special: " + name);
        }
        this.defaultImports = defaultImports;
        this.platformToKotlinClassMap = platformToKotlinClassMap;
    }

    public void setRootNamespace(@NotNull NamespaceDescriptor rootNs) {
        if (rootNs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "setRootNamespace"));
        }
        if (this.rootNamepsace != null) {
            throw new IllegalStateException("setRootNamespace() is called twice");
        }
        this.rootNamepsace = rootNs;
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return null;
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getNamespace"));
        }
        if (fqName.isRoot()) {
            return this.rootNamepsace;
        }
        NamespaceDescriptor current = this.rootNamepsace;
        for (Name simpleName : fqName.pathSegments()) {
            if ((current = current.getMemberScope().getNamespace(simpleName)) != null) continue;
            return null;
        }
        return current;
    }

    @Override
    @NotNull
    public ModuleConfiguration getModuleConfiguration() {
        ModuleConfiguration moduleConfiguration = this.moduleConfiguration;
        if (moduleConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getModuleConfiguration"));
        }
        return moduleConfiguration;
    }

    @NotNull
    public ModuleDescriptorImpl setModuleConfiguration(@NotNull ModuleConfiguration moduleConfiguration) {
        if (moduleConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "setModuleConfiguration"));
        }
        assert (this.moduleConfiguration == null) : "Trying to set module configuration twice for " + this;
        this.moduleConfiguration = moduleConfiguration;
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "setModuleConfiguration"));
        }
        return moduleDescriptorImpl;
    }

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports() {
        List<ImportPath> list = this.defaultImports;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getDefaultImports"));
        }
        return list;
    }

    @Override
    @NotNull
    public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
        PlatformToKotlinClassMap platformToKotlinClassMap = this.platformToKotlinClassMap;
        if (platformToKotlinClassMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getPlatformToKotlinClassMap"));
        }
        return platformToKotlinClassMap;
    }

    public NamespaceDescriptorImpl getRootNamespaceDescriptorImpl() {
        return (NamespaceDescriptorImpl)this.rootNamepsace;
    }

    @Override
    @NotNull
    public ModuleDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "substitute"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "substitute"));
        }
        return moduleDescriptorImpl;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitModuleDeclaration(this, data);
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "addNamespace"));
        }
        if (namespaceDescriptor.getContainingDeclaration() != this) {
            throw new IllegalStateException();
        }
        this.setRootNamespace(namespaceDescriptor);
    }
}

