/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public abstract class DeclarationDescriptorImpl
extends AnnotatedImpl
implements DeclarationDescriptor {
    @NotNull
    private final Name name;

    public DeclarationDescriptorImpl(@NotNull List<AnnotationDescriptor> annotations, @NotNull Name name) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "<init>"));
        }
        super(annotations);
        this.name = name;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = this.name;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "getName"));
        }
        return name;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        DeclarationDescriptorImpl declarationDescriptorImpl = this;
        if (declarationDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "getOriginal"));
        }
        return declarationDescriptorImpl;
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        this.accept(visitor, null);
    }

    public String toString() {
        try {
            return DescriptorRenderer.DEBUG_TEXT.render(this) + "[" + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "]";
        }
        catch (Throwable e) {
            return this.getClass().getName() + "@" + System.identityHashCode(this);
        }
    }
}

