/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetCallableReferenceExpression
extends JetExpressionImpl {
    public JetCallableReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetCallableReferenceExpression", "<init>"));
        }
        super(node);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @NotNull
    public JetSimpleNameExpression getCallableReference() {
        for (ASTNode node = this.getNode().findChildByType(JetTokens.COLONCOLON); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetSimpleNameExpression)) continue;
            JetSimpleNameExpression jetSimpleNameExpression = (JetSimpleNameExpression)psi;
            if (jetSimpleNameExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallableReferenceExpression", "getCallableReference"));
            }
            return jetSimpleNameExpression;
        }
        throw new IllegalStateException("Callable reference simple name shouldn't be parsed to null");
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetCallableReferenceExpression", "accept"));
        }
        visitor.visitCallableReferenceExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetCallableReferenceExpression", "accept"));
        }
        return visitor.visitCallableReferenceExpression(this, data);
    }
}

