/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameterList;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWithExpressionInitializer;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFunctionStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetFunctionElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lexer.JetTokens;

public class JetNamedFunction
extends JetTypeParameterListOwnerStub<PsiJetFunctionStub>
implements JetFunction,
JetWithExpressionInitializer {
    public JetNamedFunction(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetNamedFunction", "<init>"));
        }
        super(node);
    }

    public JetNamedFunction(@NotNull PsiJetFunctionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetNamedFunction", "<init>"));
        }
        super(stub, JetStubElementTypes.FUNCTION);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetNamedFunction", "accept"));
        }
        visitor.visitNamedFunction(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetNamedFunction", "accept"));
        }
        return visitor.visitNamedFunction(this, data);
    }

    public boolean hasTypeParameterListBeforeFunctionName() {
        JetTypeParameterList typeParameterList = this.getTypeParameterList();
        if (typeParameterList == null) {
            return false;
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return false;
        }
        return nameIdentifier.getTextOffset() > typeParameterList.getTextOffset();
    }

    @Override
    public boolean hasBlockBody() {
        return this.getEqualsToken() == null;
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(JetTokens.EQ);
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), JetExpression.class);
    }

    @Nullable
    public FqName getFqName() {
        PsiJetFunctionStub stub = (PsiJetFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getTopFQName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof JetFile) {
            if (((JetFile)parent).getNamespaceHeader() == null) {
                return null;
            }
            JetFile jetFile = (JetFile)parent;
            FqName fileFQN = JetPsiUtil.getFQName(jetFile);
            Name nameAsName = this.getNameAsName();
            if (nameAsName != null) {
                return fileFQN.child(nameAsName);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        JetFunctionElementType jetFunctionElementType = JetStubElementTypes.FUNCTION;
        if (jetFunctionElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedFunction", "getElementType"));
        }
        return jetFunctionElementType;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameterList list = this.getValueParameterList();
        List<JetParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedFunction", "getValueParameters"));
        }
        return list2;
    }

    @Override
    @Nullable
    public JetExpression getBodyExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return this.getReturnTypeRef() != null;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeRef() {
        IElementType tt;
        for (PsiElement child = this.getFirstChild(); child != null && (tt = child.getNode().getElementType()) != JetTokens.LPAR && tt != JetTokens.COLON; child = child.getNextSibling()) {
            if (!(child instanceof JetTypeReference)) continue;
            return (JetTypeReference)child;
        }
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getReturnTypeRef() {
        boolean colonPassed = false;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType tt = child.getNode().getElementType();
            if (tt == JetTokens.COLON) {
                colonPassed = true;
            }
            if (!colonPassed || !(child instanceof JetTypeReference)) continue;
            return (JetTypeReference)child;
        }
        return null;
    }

    @Override
    @NotNull
    public JetElement asElement() {
        JetNamedFunction jetNamedFunction = this;
        if (jetNamedFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedFunction", "asElement"));
        }
        return jetNamedFunction;
    }

    @Override
    public boolean isLocal() {
        PsiElement parent = this.getParent();
        return !(parent instanceof JetFile) && !(parent instanceof JetClassBody);
    }
}

