/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lexer.JetTokens;

public class JetWhenExpression
extends JetExpressionImpl {
    public JetWhenExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetWhenExpression", "<init>"));
        }
        super(node);
    }

    @NotNull
    public List<JetWhenEntry> getEntries() {
        List<JetWhenEntry> list = this.findChildrenByType(JetNodeTypes.WHEN_ENTRY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetWhenExpression", "getEntries"));
        }
        return list;
    }

    @Nullable
    public JetExpression getSubjectExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetWhenExpression", "accept"));
        }
        visitor.visitWhenExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetWhenExpression", "accept"));
        }
        return visitor.visitWhenExpression(this, data);
    }

    @NotNull
    public PsiElement getWhenKeywordElement() {
        PsiElement psiElement = this.findChildByType(JetTokens.WHEN_KEYWORD);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetWhenExpression", "getWhenKeywordElement"));
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getCloseBraceNode() {
        ASTNode openBraceNode = this.getNode().findChildByType(JetTokens.RBRACE);
        return openBraceNode != null ? openBraceNode.getPsi() : null;
    }

    @Nullable
    public JetExpression getElseExpression() {
        for (JetWhenEntry entry : this.getEntries()) {
            if (!entry.isElse()) continue;
            return entry.getExpression();
        }
        return null;
    }
}

