/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

class ValueArgumentsToParametersMapper {
    public static <D extends CallableDescriptor> Status mapValueArgumentsToParameters(@NotNull Call call, @NotNull TracingStrategy tracing, @NotNull ResolvedCallImpl<D> candidateCall, @NotNull Set<ValueArgument> unmappedArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        if (unmappedArguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper", "mapValueArgumentsToParameters"));
        }
        Processor processor = new Processor(call, candidateCall, tracing);
        processor.process();
        unmappedArguments.addAll(processor.unmappedArguments);
        return processor.status;
    }

    private ValueArgumentsToParametersMapper() {
    }

    private static class Processor<D extends CallableDescriptor> {
        private final Call call;
        private final TracingStrategy tracing;
        private final ResolvedCallImpl<D> candidateCall;
        private final Map<Name, ValueParameterDescriptor> parameterByName;
        private final Set<ValueArgument> unmappedArguments;
        private final Map<ValueParameterDescriptor, VarargValueArgument> varargs;
        private final Set<ValueParameterDescriptor> usedParameters;
        private Status status;
        private final ProcessorState positionedOnly;
        private final ProcessorState positionedThenNamed;

        private Processor(@NotNull Call call, @NotNull ResolvedCallImpl<D> candidateCall, @NotNull TracingStrategy tracing) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor", "<init>"));
            }
            if (candidateCall == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor", "<init>"));
            }
            if (tracing == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor", "<init>"));
            }
            this.unmappedArguments = Sets.newHashSet();
            this.varargs = Maps.newHashMap();
            this.usedParameters = Sets.newHashSet();
            this.status = Status.OK;
            this.positionedOnly = new ProcessorState(){
                private int currentParameter = 0;

                @Nullable
                public ValueParameterDescriptor nextValueParameter() {
                    List<ValueParameterDescriptor> parameters = Processor.this.candidateCall.getCandidateDescriptor().getValueParameters();
                    if (this.currentParameter >= parameters.size()) {
                        return null;
                    }
                    ValueParameterDescriptor head = parameters.get(this.currentParameter);
                    if (head.getVarargElementType() == null) {
                        ++this.currentParameter;
                    }
                    return head;
                }

                @Override
                public ProcessorState processNamedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor$1", "processNamedArgument"));
                    }
                    return Processor.this.positionedThenNamed.processNamedArgument(argument);
                }

                @Override
                public ProcessorState processPositionedArgument(@NotNull ValueArgument argument, int index) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor$1", "processPositionedArgument"));
                    }
                    ValueParameterDescriptor valueParameterDescriptor = this.nextValueParameter();
                    if (valueParameterDescriptor != null) {
                        Processor.this.usedParameters.add(valueParameterDescriptor);
                        Processor.this.putVararg(valueParameterDescriptor, argument);
                    } else {
                        Processor.this.report(Errors.TOO_MANY_ARGUMENTS.on(argument.asElement(), (CallableDescriptor)Processor.this.candidateCall.getCandidateDescriptor()));
                        Processor.this.unmappedArguments.add(argument);
                        Processor.this.setStatus(Status.WEAK_ERROR);
                    }
                    return Processor.this.positionedOnly;
                }
            };
            this.positionedThenNamed = new ProcessorState(){

                @Override
                public ProcessorState processNamedArgument(@NotNull ValueArgument argument) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor$2", "processNamedArgument"));
                    }
                    assert (argument.isNamed());
                    JetSimpleNameExpression nameReference = argument.getArgumentName().getReferenceExpression();
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)Processor.this.parameterByName.get(nameReference.getReferencedNameAsName());
                    if (valueParameterDescriptor == null) {
                        Processor.this.report(Errors.NAMED_PARAMETER_NOT_FOUND.on(nameReference, nameReference));
                        Processor.this.unmappedArguments.add(argument);
                        Processor.this.setStatus(Status.WEAK_ERROR);
                    } else {
                        Processor.this.candidateCall.getTrace().record(BindingContext.REFERENCE_TARGET, nameReference, valueParameterDescriptor);
                        if (!Processor.this.usedParameters.add(valueParameterDescriptor)) {
                            Processor.this.report(Errors.ARGUMENT_PASSED_TWICE.on(nameReference));
                            Processor.this.unmappedArguments.add(argument);
                            Processor.this.setStatus(Status.WEAK_ERROR);
                        } else {
                            Processor.this.putVararg(valueParameterDescriptor, argument);
                        }
                    }
                    return Processor.this.positionedThenNamed;
                }

                @Override
                public ProcessorState processPositionedArgument(@NotNull ValueArgument argument, int index) {
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor$2", "processPositionedArgument"));
                    }
                    Processor.this.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on(argument.asElement()));
                    Processor.this.setStatus(Status.WEAK_ERROR);
                    return Processor.this.positionedThenNamed;
                }
            };
            this.call = call;
            this.tracing = tracing;
            this.candidateCall = candidateCall;
            this.parameterByName = Maps.newHashMap();
            for (ValueParameterDescriptor valueParameter : candidateCall.getCandidateDescriptor().getValueParameters()) {
                this.parameterByName.put(valueParameter.getName(), valueParameter);
            }
        }

        public void process() {
            ProcessorState state = this.positionedOnly;
            List<? extends ValueArgument> arguments = this.call.getValueArguments();
            for (int i = 0; i < arguments.size(); ++i) {
                ValueArgument valueArgument = arguments.get(i);
                state = valueArgument.isNamed() ? state.processNamedArgument(valueArgument) : state.processPositionedArgument(valueArgument, i);
            }
            this.processFunctionLiteralArguments();
            this.reportUnmappedParameters();
            this.checkReceiverArgument();
            assert (this.candidateCall.getThisObject().exists() == (this.candidateCall.getResultingDescriptor().getExpectedThisObject() != null)) : "Shouldn't happen because of TaskPrioritizer: " + this.candidateCall.getCandidateDescriptor();
        }

        private void processFunctionLiteralArguments() {
            D candidate = this.candidateCall.getCandidateDescriptor();
            List<ValueParameterDescriptor> valueParameters = candidate.getValueParameters();
            List<JetExpression> functionLiteralArguments = this.call.getFunctionLiteralArguments();
            if (!functionLiteralArguments.isEmpty()) {
                JetExpression possiblyLabeledFunctionLiteral = functionLiteralArguments.get(0);
                if (valueParameters.isEmpty()) {
                    this.report(Errors.TOO_MANY_ARGUMENTS.on(possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                    this.setStatus(Status.ERROR);
                } else {
                    ValueParameterDescriptor valueParameterDescriptor = valueParameters.get(valueParameters.size() - 1);
                    if (valueParameterDescriptor.getVarargElementType() != null) {
                        this.report(Errors.VARARG_OUTSIDE_PARENTHESES.on(possiblyLabeledFunctionLiteral));
                        this.setStatus(Status.ERROR);
                    } else if (!this.usedParameters.add(valueParameterDescriptor)) {
                        this.report(Errors.TOO_MANY_ARGUMENTS.on(possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                        this.setStatus(Status.WEAK_ERROR);
                    } else {
                        this.putVararg(valueParameterDescriptor, CallMaker.makeValueArgument(possiblyLabeledFunctionLiteral));
                    }
                }
                for (int i = 1; i < functionLiteralArguments.size(); ++i) {
                    JetExpression argument = functionLiteralArguments.get(i);
                    this.report(Errors.MANY_FUNCTION_LITERAL_ARGUMENTS.on(argument));
                    this.setStatus(Status.WEAK_ERROR);
                }
            }
        }

        private void reportUnmappedParameters() {
            List<ValueParameterDescriptor> valueParameters = this.candidateCall.getCandidateDescriptor().getValueParameters();
            for (ValueParameterDescriptor valueParameter : valueParameters) {
                if (this.usedParameters.contains(valueParameter)) continue;
                if (valueParameter.hasDefaultValue()) {
                    this.candidateCall.recordValueArgument(valueParameter, DefaultValueArgument.DEFAULT);
                    continue;
                }
                if (valueParameter.getVarargElementType() != null) {
                    this.candidateCall.recordValueArgument(valueParameter, new VarargValueArgument());
                    continue;
                }
                this.tracing.noValueForParameter(this.candidateCall.getTrace(), valueParameter);
                this.setStatus(Status.ERROR);
            }
        }

        private void checkReceiverArgument() {
            D candidate = this.candidateCall.getCandidateDescriptor();
            ReceiverParameterDescriptor receiverParameter = candidate.getReceiverParameter();
            ReceiverValue receiverArgument = this.candidateCall.getReceiverArgument();
            if (receiverParameter != null && !receiverArgument.exists()) {
                this.tracing.missingReceiver(this.candidateCall.getTrace(), receiverParameter);
                this.setStatus(Status.ERROR);
            }
            if (receiverParameter == null && receiverArgument.exists()) {
                this.tracing.noReceiverAllowed(this.candidateCall.getTrace());
                if (this.call.getCalleeExpression() instanceof JetSimpleNameExpression) {
                    this.setStatus(Status.STRONG_ERROR);
                } else {
                    this.setStatus(Status.ERROR);
                }
            }
        }

        private void putVararg(ValueParameterDescriptor valueParameterDescriptor, ValueArgument valueArgument) {
            if (valueParameterDescriptor.getVarargElementType() != null) {
                VarargValueArgument vararg = this.varargs.get(valueParameterDescriptor);
                if (vararg == null) {
                    vararg = new VarargValueArgument();
                    this.varargs.put(valueParameterDescriptor, vararg);
                    this.candidateCall.recordValueArgument(valueParameterDescriptor, vararg);
                }
                vararg.addArgument(valueArgument);
            } else {
                LeafPsiElement spread = valueArgument.getSpreadElement();
                if (spread != null) {
                    this.candidateCall.getTrace().report(Errors.NON_VARARG_SPREAD.on(spread));
                    this.setStatus(Status.WEAK_ERROR);
                }
                ExpressionValueArgument argument = new ExpressionValueArgument(valueArgument);
                this.candidateCall.recordValueArgument(valueParameterDescriptor, argument);
            }
        }

        private void setStatus(@NotNull Status newStatus) {
            if (newStatus == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/ValueArgumentsToParametersMapper$Processor", "setStatus"));
            }
            this.status = this.status.compose(newStatus);
        }

        private void report(Diagnostic diagnostic) {
            this.candidateCall.getTrace().report(diagnostic);
        }

        private static interface ProcessorState {
            public ProcessorState processNamedArgument(@NotNull ValueArgument var1);

            public ProcessorState processPositionedArgument(@NotNull ValueArgument var1, int var2);
        }
    }

    public static enum Status {
        STRONG_ERROR(false),
        ERROR(false),
        WEAK_ERROR(false),
        OK(true);

        private final boolean success;

        private Status(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Status compose(Status other) {
            if (this == STRONG_ERROR || other == STRONG_ERROR) {
                return STRONG_ERROR;
            }
            if (this == ERROR || other == ERROR) {
                return ERROR;
            }
            if (this == WEAK_ERROR || other == WEAK_ERROR) {
                return WEAK_ERROR;
            }
            return this;
        }
    }
}

