/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinder;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaPackageImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JavaClassFinderImpl
implements JavaClassFinder {
    private PsiClassFinder psiClassFinder;

    public void setPsiClassFinder(@NotNull PsiClassFinder psiClassFinder) {
        if (psiClassFinder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "setPsiClassFinder"));
        }
        this.psiClassFinder = psiClassFinder;
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "findClass"));
        }
        PsiClass psiClass = this.psiClassFinder.findPsiClass(fqName);
        return psiClass == null ? null : new JavaClassImpl(psiClass);
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JavaClassFinderImpl", "findPackage"));
        }
        PsiPackage psiPackage = this.psiClassFinder.findPsiPackage(fqName);
        return psiPackage == null ? null : new JavaPackageImpl(psiPackage);
    }
}

