/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMapBuilder;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class JavaToKotlinClassMap
extends JavaToKotlinClassMapBuilder
implements PlatformToKotlinClassMap {
    private static final FqName JAVA_LANG_DEPRECATED = new FqName("java.lang.Deprecated");
    private static JavaToKotlinClassMap instance = null;
    private final Map<FqName, ClassDescriptor> classDescriptorMap = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqName, ClassDescriptor> classDescriptorMapForCovariantPositions = new HashMap<FqName, ClassDescriptor>();
    private final Map<String, JetType> primitiveTypesMap = new HashMap<String, JetType>();
    private final Multimap<FqName, ClassDescriptor> packagesWithMappedClasses = HashMultimap.create();

    @NotNull
    public static JavaToKotlinClassMap getInstance() {
        if (instance == null) {
            instance = new JavaToKotlinClassMap();
        }
        JavaToKotlinClassMap javaToKotlinClassMap = instance;
        if (javaToKotlinClassMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "getInstance"));
        }
        return javaToKotlinClassMap;
    }

    private JavaToKotlinClassMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        PrimitiveType primitiveType;
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.register(jvmPrimitiveType.getWrapper().getFqName(), builtIns.getPrimitiveClassDescriptor(primitiveType));
        }
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.primitiveTypesMap.put(jvmPrimitiveType.getName(), KotlinBuiltIns.getInstance().getPrimitiveJetType(primitiveType));
            this.primitiveTypesMap.put("[" + jvmPrimitiveType.getName(), KotlinBuiltIns.getInstance().getPrimitiveArrayJetType(primitiveType));
            this.primitiveTypesMap.put(jvmPrimitiveType.getWrapper().getFqName().asString(), KotlinBuiltIns.getInstance().getNullablePrimitiveJetType(primitiveType));
        }
        this.primitiveTypesMap.put("void", KotlinBuiltIns.getInstance().getUnitType());
    }

    @Nullable
    public JetType mapPrimitiveKotlinClass(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPrimitiveKotlinClass"));
        }
        return this.primitiveTypesMap.get(name);
    }

    @Nullable
    public ClassDescriptor mapKotlinClass(@NotNull FqName fqName, @NotNull TypeUsage typeUsage) {
        ClassDescriptor descriptor;
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapKotlinClass"));
        }
        if (typeUsage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapKotlinClass"));
        }
        if ((typeUsage == TypeUsage.MEMBER_SIGNATURE_COVARIANT || typeUsage == TypeUsage.SUPERTYPE) && (descriptor = this.classDescriptorMapForCovariantPositions.get(fqName)) != null) {
            return descriptor;
        }
        return this.classDescriptorMap.get(fqName);
    }

    @Nullable
    public AnnotationDescriptor mapToAnnotationClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapToAnnotationClass"));
        }
        ClassDescriptor classDescriptor = this.classDescriptorMap.get(fqName);
        if (classDescriptor != null && fqName.equals(JAVA_LANG_DEPRECATED)) {
            return JavaToKotlinClassMap.getAnnotationDescriptorForJavaLangDeprecated(classDescriptor);
        }
        return null;
    }

    @NotNull
    private static AnnotationDescriptor getAnnotationDescriptorForJavaLangDeprecated(@NotNull ClassDescriptor annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "getAnnotationDescriptorForJavaLangDeprecated"));
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor();
        annotation.setAnnotationType(annotationClass.getDefaultType());
        ValueParameterDescriptor value = DescriptorResolverUtils.getAnnotationParameterByName(JavaAnnotationResolver.DEFAULT_ANNOTATION_MEMBER_NAME, annotationClass);
        assert (value != null) : "jet.deprecated must have one parameter called value";
        annotation.setValueArgument(value, new StringValue("Deprecated in Java"));
        AnnotationDescriptor annotationDescriptor = annotation;
        if (annotationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "getAnnotationDescriptorForJavaLangDeprecated"));
        }
        return annotationDescriptor;
    }

    private static FqName getJavaClassFqName(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "getJavaClassFqName"));
        }
        return new FqName(javaClass.getName().replace('$', '.'));
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            this.register(JavaToKotlinClassMap.getJavaClassFqName(javaClass), kotlinDescriptor);
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            FqName javaClassName = JavaToKotlinClassMap.getJavaClassFqName(javaClass);
            this.register(javaClassName, kotlinDescriptor);
            this.registerCovariant(javaClassName, kotlinMutableDescriptor);
        }
    }

    private void register(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "register"));
        }
        this.classDescriptorMap.put(javaClassName, kotlinDescriptor);
        this.packagesWithMappedClasses.put(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerCovariant(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "registerCovariant"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "registerCovariant"));
        }
        this.classDescriptorMapForCovariantPositions.put(javaClassName, kotlinDescriptor);
        this.packagesWithMappedClasses.put(javaClassName.parent(), kotlinDescriptor);
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        ClassDescriptor kotlinAnalog = this.classDescriptorMap.get(fqName);
        ClassDescriptor kotlinCovariantAnalog = this.classDescriptorMapForCovariantPositions.get(fqName);
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>(2);
        if (kotlinAnalog != null) {
            descriptors.add(kotlinAnalog);
        }
        if (kotlinCovariantAnalog != null) {
            descriptors.add(kotlinCovariantAnalog);
        }
        ArrayList<ClassDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        FqNameUnsafe className = DescriptorUtils.getFQName(classDescriptor);
        if (!className.isSafe()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return list;
        }
        Collection<ClassDescriptor> collection = this.mapPlatformClass(className.toSafe());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClassesInside(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClassesInside"));
        }
        FqNameUnsafe fqName = DescriptorUtils.getFQName(containingDeclaration);
        if (!fqName.isSafe()) {
            List<ClassDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClassesInside"));
            }
            return list;
        }
        Collection<ClassDescriptor> collection = this.packagesWithMappedClasses.get(fqName.toSafe());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/mapping/JavaToKotlinClassMap", "mapPlatformClassesInside"));
        }
        return collection;
    }
}

