/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationArgumentResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedStorageManager;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;

public class AnnotationDescriptorDeserializer
implements AnnotationDeserializer {
    private static final Logger LOG = Logger.getInstance(AnnotationDescriptorDeserializer.class);
    private JavaClassResolver javaClassResolver;
    private KotlinClassFinder kotlinClassFinder;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private final MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Map<MemberSignature, List<AnnotationDescriptor>>> memberAnnotations = this.storageManager.createMemoizedFunction(new MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Map<MemberSignature, List<AnnotationDescriptor>>>(){

        @Override
        @NotNull
        public Map<MemberSignature, List<AnnotationDescriptor>> fun(@NotNull KotlinJvmBinaryClass kotlinClass) {
            Map map;
            if (kotlinClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$1", "fun"));
            }
            try {
                map = AnnotationDescriptorDeserializer.this.loadMemberAnnotationsFromClass(kotlinClass);
            }
            catch (IOException e) {
                LOG.error("Error loading member annotations from Kotlin class: " + kotlinClass, e);
                Map<MemberSignature, List<AnnotationDescriptor>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$1", "fun"));
                }
                return map2;
            }
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$1", "fun"));
            }
            return map;
        }
    }, StorageManager.ReferenceKind.STRONG);

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    public void setKotlinClassFinder(KotlinClassFinder kotlinClassFinder) {
        this.kotlinClassFinder = kotlinClassFinder;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class classProto) {
        List<AnnotationDescriptor> list;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        KotlinJvmBinaryClass kotlinClass = this.findKotlinClassByDescriptor(descriptor);
        if (kotlinClass == null) {
            LOG.error("Kotlin class for loading class annotations is not found: " + descriptor);
            List<AnnotationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
            }
            return list2;
        }
        try {
            list = this.loadClassAnnotationsFromClass(kotlinClass);
        }
        catch (IOException e) {
            LOG.error("Error loading member annotations from Kotlin class: " + kotlinClass, e);
            List<AnnotationDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
            }
            return list3;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotations"));
        }
        return list;
    }

    @Nullable
    private KotlinJvmBinaryClass findKotlinClassByDescriptor(@NotNull ClassOrNamespaceDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findKotlinClassByDescriptor"));
        }
        if (descriptor instanceof ClassDescriptor) {
            return this.kotlinClassFinder.find(DeserializedResolverUtils.kotlinFqNameToJavaFqName(DeserializedResolverUtils.naiveKotlinFqName((ClassDescriptor)descriptor)));
        }
        if (descriptor instanceof NamespaceDescriptor) {
            return this.kotlinClassFinder.find(PackageClassUtils.getPackageClassFqName(DescriptorUtils.getFQName(descriptor).toSafe()));
        }
        throw new IllegalStateException("Unrecognized descriptor: " + descriptor);
    }

    @NotNull
    private List<AnnotationDescriptor> loadClassAnnotationsFromClass(@NotNull KotlinJvmBinaryClass kotlinClass) throws IOException {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotationsFromClass"));
        }
        final ArrayList<AnnotationDescriptor> result = new ArrayList<AnnotationDescriptor>();
        kotlinClass.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(){

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName className) {
                if (className == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$2", "visitAnnotation"));
                }
                return AnnotationDescriptorDeserializer.this.resolveAnnotation(className, result);
            }

            @Override
            public void visitEnd() {
            }
        });
        ArrayList<AnnotationDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadClassAnnotationsFromClass"));
        }
        return arrayList;
    }

    private static boolean ignoreAnnotation(@NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "ignoreAnnotation"));
        }
        return className.equals(JvmAnnotationNames.KOTLIN_CLASS) || className.equals(JvmAnnotationNames.KOTLIN_PACKAGE) || className.getInternalName().startsWith("jet/runtime/typeinfo/");
    }

    @Nullable
    private KotlinJvmBinaryClass.AnnotationArgumentVisitor resolveAnnotation(@NotNull JvmClassName className, final @NotNull List<AnnotationDescriptor> result) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotation"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotation"));
        }
        if (AnnotationDescriptorDeserializer.ignoreAnnotation(className)) {
            return null;
        }
        final ClassDescriptor annotationClass = this.resolveAnnotationClass(className);
        final AnnotationDescriptor annotation = new AnnotationDescriptor();
        annotation.setAnnotationType(annotationClass.getDefaultType());
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(){

            @Override
            public void visit(@Nullable Name name, @Nullable Object value) {
                if (name != null) {
                    ErrorValue argument = JavaAnnotationArgumentResolver.resolveCompileTimeConstantValue(value, null);
                    this.setArgumentValueByName(name, argument != null ? argument : ErrorValue.create("Unsupported annotation argument: " + name));
                }
            }

            @Override
            public void visitEnum(@NotNull Name name, @NotNull JvmClassName enumClassName, @NotNull Name enumEntryName) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitEnum"));
                }
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitEnum"));
                }
                this.setArgumentValueByName(name, this.enumEntryValue(enumClassName, enumEntryName));
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitArray(@NotNull Name name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "visitArray"));
                }
                return null;
            }

            @NotNull
            private CompileTimeConstant<?> enumEntryValue(@NotNull JvmClassName enumClassName, @NotNull Name name) {
                VariableDescriptor property;
                Collection<VariableDescriptor> properties;
                ClassDescriptor classObject;
                if (enumClassName == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                }
                ClassDescriptor enumClass = AnnotationDescriptorDeserializer.this.javaClassResolver.resolveClass(enumClassName.getFqName(), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
                if (enumClass != null && enumClass.getKind() == ClassKind.ENUM_CLASS && (classObject = enumClass.getClassObjectDescriptor()) != null && (properties = classObject.getDefaultType().getMemberScope().getProperties(name)).size() == 1 && (property = properties.iterator().next()) instanceof PropertyDescriptor) {
                    EnumValue enumValue = new EnumValue((PropertyDescriptor)property);
                    if (enumValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                    }
                    return enumValue;
                }
                ErrorValue errorValue = ErrorValue.create("Unresolved enum entry: " + enumClassName.getFqName() + "." + name);
                if (errorValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "enumEntryValue"));
                }
                return errorValue;
            }

            @Override
            public void visitEnd() {
                result.add(annotation);
            }

            private void setArgumentValueByName(@NotNull Name name, @NotNull CompileTimeConstant<?> argumentValue) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "setArgumentValueByName"));
                }
                if (argumentValue == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$3", "setArgumentValueByName"));
                }
                ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(name, annotationClass);
                if (parameter != null) {
                    annotation.setValueArgument(parameter, argumentValue);
                }
            }
        };
    }

    @NotNull
    private ClassDescriptor resolveAnnotationClass(@NotNull JvmClassName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotationClass"));
        }
        ClassDescriptor annotationClass = this.javaClassResolver.resolveClass(className.getFqName(), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        ClassDescriptor classDescriptor = annotationClass != null ? annotationClass : ErrorUtils.getErrorClass();
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "resolveAnnotationClass"));
        }
        return classDescriptor;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        List<AnnotationDescriptor> annotations;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        MemberSignature signature = AnnotationDescriptorDeserializer.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            List<AnnotationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
            }
            return list;
        }
        KotlinJvmBinaryClass kotlinClass = this.findClassWithMemberAnnotations(container, proto, nameResolver);
        if (kotlinClass == null) {
            LOG.error("Kotlin class for loading member annotations is not found: " + container);
        }
        List<Object> list = (annotations = this.memberAnnotations.fun(kotlinClass).get(signature)) == null ? Collections.emptyList() : annotations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadCallableAnnotations"));
        }
        return list;
    }

    @Nullable
    private KotlinJvmBinaryClass findClassWithMemberAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassWithMemberAnnotations"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassWithMemberAnnotations"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "findClassWithMemberAnnotations"));
        }
        if (container instanceof NamespaceDescriptor) {
            Name name = AnnotationDescriptorDeserializer.loadSrcClassName(proto, nameResolver);
            if (name != null) {
                return this.kotlinClassFinder.find(AnnotationDescriptorDeserializer.getSrcClassFqName((NamespaceDescriptor)container, name));
            }
            return null;
        }
        if (container instanceof ClassDescriptor && ((ClassDescriptor)container).getKind() == ClassKind.CLASS_OBJECT && AnnotationDescriptorDeserializer.isStaticFieldInOuter(proto)) {
            return this.findKotlinClassByDescriptor((ClassOrNamespaceDescriptor)container.getContainingDeclaration());
        }
        return this.findKotlinClassByDescriptor(container);
    }

    @NotNull
    private static FqName getSrcClassFqName(@NotNull NamespaceDescriptor container, @NotNull Name name) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getSrcClassFqName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getSrcClassFqName"));
        }
        FqName fqName = PackageClassUtils.getPackageClassFqName(DescriptorUtils.getFQName(container).toSafe()).parent().child(name);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getSrcClassFqName"));
        }
        return fqName;
    }

    @Nullable
    private static Name loadSrcClassName(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadSrcClassName"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadSrcClassName"));
        }
        return proto.hasExtension(JavaProtoBuf.srcClassName) ? nameResolver.getName(proto.getExtension(JavaProtoBuf.srcClassName)) : null;
    }

    private static boolean isStaticFieldInOuter(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "isStaticFieldInOuter"));
        }
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return false;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        return propertySignature.hasField() && propertySignature.getField().getIsStaticInOuter();
    }

    @Nullable
    private static MemberSignature getCallableSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getCallableSignature"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getCallableSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "getCallableSignature"));
        }
        switch (kind) {
            case FUNCTION: {
                if (!proto.hasExtension(JavaProtoBuf.methodSignature)) break;
                JavaProtoBuf.JavaMethodSignature signature = proto.getExtension(JavaProtoBuf.methodSignature);
                return new SignatureDeserializer(nameResolver).methodSignature(signature);
            }
            case PROPERTY_GETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
                return new SignatureDeserializer(nameResolver).methodSignature(propertySignature.getGetter());
            }
            case PROPERTY_SETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
                return new SignatureDeserializer(nameResolver).methodSignature(propertySignature.getSetter());
            }
            case PROPERTY: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
                if (propertySignature.hasField()) {
                    JavaProtoBuf.JavaFieldSignature field = propertySignature.getField();
                    String type = new SignatureDeserializer(nameResolver).typeDescriptor(field.getType());
                    Name name = nameResolver.getName(field.getName());
                    return MemberSignature.fromFieldNameAndDesc(name, type);
                }
                if (!propertySignature.hasSyntheticMethodName()) break;
                Name name = nameResolver.getName(propertySignature.getSyntheticMethodName());
                return MemberSignature.fromMethodNameAndDesc(name, "()V");
            }
        }
        return null;
    }

    @NotNull
    private Map<MemberSignature, List<AnnotationDescriptor>> loadMemberAnnotationsFromClass(@NotNull KotlinJvmBinaryClass kotlinClass) throws IOException {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadMemberAnnotationsFromClass"));
        }
        final HashMap<MemberSignature, List<AnnotationDescriptor>> memberAnnotations = new HashMap<MemberSignature, List<AnnotationDescriptor>>();
        kotlinClass.loadMemberAnnotations(new KotlinJvmBinaryClass.MemberVisitor(){

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitMethod"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitMethod"));
                }
                return this.annotationVisitor(MemberSignature.fromMethodNameAndDesc(name, desc));
            }

            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitField"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "visitField"));
                }
                return this.annotationVisitor(MemberSignature.fromFieldNameAndDesc(name, desc));
            }

            @NotNull
            private KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor(final @NotNull MemberSignature signature) {
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "annotationVisitor"));
                }
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = new KotlinJvmBinaryClass.AnnotationVisitor(){
                    private final List<AnnotationDescriptor> result = new ArrayList<AnnotationDescriptor>();

                    @Override
                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull JvmClassName className) {
                        if (className == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4$1", "visitAnnotation"));
                        }
                        return AnnotationDescriptorDeserializer.this.resolveAnnotation(className, this.result);
                    }

                    @Override
                    public void visitEnd() {
                        if (!this.result.isEmpty()) {
                            memberAnnotations.put(signature, this.result);
                        }
                    }
                };
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$4", "annotationVisitor"));
                }
                return annotationVisitor;
            }
        });
        HashMap<MemberSignature, List<AnnotationDescriptor>> hashMap = memberAnnotations;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadMemberAnnotationsFromClass"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoBuf.Callable.ValueParameter parameterProto) {
        if (parameterProto == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer", "loadValueParameterAnnotations"));
        }
        throw new UnsupportedOperationException();
    }

    private static class SignatureDeserializer {
        private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
        private final NameResolver nameResolver;

        public SignatureDeserializer(@NotNull NameResolver nameResolver) {
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "<init>"));
            }
            this.nameResolver = nameResolver;
        }

        @NotNull
        public MemberSignature methodSignature(@NotNull JavaProtoBuf.JavaMethodSignature signature) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "methodSignature"));
            }
            Name name = this.nameResolver.getName(signature.getName());
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            int length = signature.getParameterTypeCount();
            for (int i = 0; i < length; ++i) {
                this.typeDescriptor(signature.getParameterType(i), sb);
            }
            sb.append(')');
            this.typeDescriptor(signature.getReturnType(), sb);
            MemberSignature memberSignature = MemberSignature.fromMethodNameAndDesc(name, sb.toString());
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "methodSignature"));
            }
            return memberSignature;
        }

        @NotNull
        public String typeDescriptor(@NotNull JavaProtoBuf.JavaType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            String string = this.typeDescriptor(type, new StringBuilder()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            return string;
        }

        @NotNull
        private StringBuilder typeDescriptor(@NotNull JavaProtoBuf.JavaType type, @NotNull StringBuilder sb) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            for (int i = 0; i < type.getArrayDimension(); ++i) {
                sb.append('[');
            }
            if (type.hasPrimitiveType()) {
                sb.append(PRIMITIVE_TYPES[type.getPrimitiveType().ordinal()]);
            } else {
                sb.append("L");
                sb.append(SignatureDeserializer.fqNameToInternalName(this.nameResolver.getFqName(type.getClassFqName())));
                sb.append(";");
            }
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            return stringBuilder;
        }

        @NotNull
        private static String fqNameToInternalName(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "fqNameToInternalName"));
            }
            String string = fqName.asString().replace('.', '/');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$SignatureDeserializer", "fqNameToInternalName"));
            }
            return string;
        }
    }

    private static final class MemberSignature {
        private final String signature;

        private MemberSignature(@NotNull String signature) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "<init>"));
            }
            this.signature = signature;
        }

        @NotNull
        public static MemberSignature fromMethodNameAndDesc(@NotNull Name name, @NotNull String desc) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodNameAndDesc"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodNameAndDesc"));
            }
            MemberSignature memberSignature = new MemberSignature(name.asString() + desc);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromMethodNameAndDesc"));
            }
            return memberSignature;
        }

        @NotNull
        public static MemberSignature fromFieldNameAndDesc(@NotNull Name name, @NotNull String desc) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromFieldNameAndDesc"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromFieldNameAndDesc"));
            }
            MemberSignature memberSignature = new MemberSignature(name.asString() + "#" + desc);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/AnnotationDescriptorDeserializer$MemberSignature", "fromFieldNameAndDesc"));
            }
            return memberSignature;
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MemberSignature && this.signature.equals(((MemberSignature)o).signature);
        }

        public String toString() {
            return this.signature;
        }
    }
}

